"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.retrieveFieldsFromFilter = exports.createHostsFilter = void 0;
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createHostsFilter = (hostNames, dataView) => {
  return {
    query: {
      terms: {
        'host.name': hostNames
      }
    },
    meta: dataView ? {
      value: hostNames.join(),
      type: 'phrases',
      params: hostNames,
      index: dataView.id,
      key: 'host.name'
    } : {}
  };
};
exports.createHostsFilter = createHostsFilter;
const retrieveFieldsFromFilter = (filters, fields = []) => {
  for (const filter of filters) {
    if ((0, _esQuery.isCombinedFilter)(filter)) {
      retrieveFieldsFromFilter(filter.meta.params, fields);
    }
    if (filter.meta.key) {
      fields.push(filter.meta.key);
    }
  }
  return fields;
};
exports.retrieveFieldsFromFilter = retrieveFieldsFromFilter;