"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostsLandingPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _public2 = require("@kbn/observability-plugin/public");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _enable_hosts_view_page = require("./components/enable_hosts_view_page/enable_hosts_view_page");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HostsLandingPage = () => {
  var _uiSettings$get$;
  const {
    services: {
      uiSettings,
      application
    }
  } = (0, _public.useKibana)();
  const canEditAdvancedSettings = application === null || application === void 0 ? void 0 : application.capabilities.advancedSettings.save;
  const isHostViewEnabled = (0, _useObservable.default)((_uiSettings$get$ = uiSettings === null || uiSettings === void 0 ? void 0 : uiSettings.get$(_public2.enableInfrastructureHostsView)) !== null && _uiSettings$get$ !== void 0 ? _uiSettings$get$ : new _rxjs.Observable(subs => subs.next(false)));
  if (isHostViewEnabled) {
    return /*#__PURE__*/_react.default.createElement(_.HostsPage, null);
  }
  if (canEditAdvancedSettings) {
    return /*#__PURE__*/_react.default.createElement(_enable_hosts_view_page.EnableHostsViewPage, {
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        iconType: "check",
        color: "primary",
        "data-test-subj": "hostsView-enable-feature-button",
        onClick: () => {
          uiSettings === null || uiSettings === void 0 ? void 0 : uiSettings.set(_public2.enableInfrastructureHostsView, true);
        }
      }, _i18n.i18n.translate('xpack.infra.hostsViewPage.landing.enableHostsView', {
        defaultMessage: 'Enable hosts view'
      }))
    });
  }
  return /*#__PURE__*/_react.default.createElement(_enable_hosts_view_page.EnableHostsViewPage, {
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      "data-test-subj": "hostView-no-enable-access",
      size: "s",
      color: "warning"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.infra.hostsViewPage.landing.calloutReachOutToYourKibanaAdministrator', {
      defaultMessage: `Your user role doesn’t have sufficient privileges to enable this feature - please 
                reach out to your Kibana Administrator and ask them to visit this page to enable this feature.`
    })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.hostsViewPage.landing.calloutRoleClarificationWithDocsLink",
      defaultMessage: "They will need a role with access to Advanced settings in Kibana. {docsLink}",
      values: {
        docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          "data-test-subj": "hostsView-docs-link",
          href: "https://www.elastic.co/guide/en/kibana/current/kibana-privileges.html#kibana-feature-privileges"
        }, _i18n.i18n.translate('xpack.infra.hostsViewPage.landing.learnMore', {
          defaultMessage: 'Learn more'
        }))
      }
    })))
  });
};
exports.HostsLandingPage = HostsLandingPage;