"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHostsUrlState = void 0;
var _react = require("react");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var rt = _interopRequireWildcard(require("io-ts"));
var _pipeable = require("fp-ts/lib/pipeable");
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var _esQuery = require("@kbn/es-query");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _use_url_state = require("../../../../utils/use_url_state");
var _use_kibana_timefilter_time = require("../../../../hooks/use_kibana_timefilter_time");
var _constants = require("../constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_QUERY = {
  language: 'kuery',
  query: ''
};
const DEFAULT_FROM_MINUTES_VALUE = 15;
const INITIAL_DATE_RANGE = {
  from: `now-${DEFAULT_FROM_MINUTES_VALUE}m`,
  to: 'now'
};
const INITIAL_HOSTS_STATE = {
  query: DEFAULT_QUERY,
  filters: [],
  panelFilters: [],
  dateRange: INITIAL_DATE_RANGE,
  limit: _constants.DEFAULT_HOST_LIMIT
};
const reducer = (prevState, params) => {
  const payload = Object.fromEntries(Object.entries(params).filter(([_, v]) => !!v));
  return {
    ...prevState,
    ...payload
  };
};
const useHostsUrlState = () => {
  const [getTime] = (0, _use_kibana_timefilter_time.useKibanaTimefilterTime)(INITIAL_DATE_RANGE);
  const [localStorageHostLimit, setLocalStorageHostLimit] = (0, _useLocalStorage.default)(_constants.LOCAL_STORAGE_HOST_LIMIT_KEY, INITIAL_HOSTS_STATE.limit);
  const [urlState, setUrlState] = (0, _use_url_state.useUrlState)({
    defaultState: {
      ...INITIAL_HOSTS_STATE,
      dateRange: getTime(),
      limit: localStorageHostLimit !== null && localStorageHostLimit !== void 0 ? localStorageHostLimit : INITIAL_HOSTS_STATE.limit
    },
    decodeUrlState,
    encodeUrlState,
    urlStateKey: '_a',
    writeDefaultState: true
  });
  const [search, setSearch] = (0, _react.useReducer)(reducer, urlState);
  if (!(0, _fastDeepEqual.default)(search, urlState)) {
    setUrlState(search);
    if (localStorageHostLimit !== search.limit) {
      setLocalStorageHostLimit(search.limit);
    }
  }
  (0, _use_kibana_timefilter_time.useSyncKibanaTimeFilterTime)(INITIAL_DATE_RANGE, urlState.dateRange, dateRange => setSearch({
    dateRange
  }));
  return [search, setSearch];
};
exports.useHostsUrlState = useHostsUrlState;
const HostsFilterRT = rt.intersection([rt.type({
  meta: rt.partial({
    alias: rt.union([rt.null, rt.string]),
    disabled: rt.boolean,
    negate: rt.boolean,
    controlledBy: rt.string,
    group: rt.string,
    index: rt.string,
    isMultiIndex: rt.boolean,
    type: rt.string,
    key: rt.string,
    params: rt.any,
    value: rt.any
  })
}), rt.partial({
  query: rt.record(rt.string, rt.any),
  $state: rt.type({
    store: (0, _securitysolutionIoTsTypes.enumeration)('FilterStateStore', _esQuery.FilterStateStore)
  })
})]);
const HostsFiltersRT = rt.array(HostsFilterRT);
const HostsQueryStateRT = rt.type({
  language: rt.string,
  query: rt.union([rt.string, rt.record(rt.string, rt.any)])
});
const StringDateRangeRT = rt.intersection([rt.type({
  from: rt.string,
  to: rt.string
}), rt.partial({
  mode: rt.union([rt.literal('absolute'), rt.literal('relative')])
})]);
const HostsStateRT = rt.type({
  filters: HostsFiltersRT,
  panelFilters: HostsFiltersRT,
  query: HostsQueryStateRT,
  dateRange: StringDateRangeRT,
  limit: rt.number
});
const encodeUrlState = HostsStateRT.encode;
const decodeUrlState = value => {
  return (0, _pipeable.pipe)(HostsStateRT.decode(value), (0, _Either.fold)((0, _function.constant)(undefined), _function.identity));
};