"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogsSearchUrlState = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _pipeable = require("fp-ts/lib/pipeable");
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _use_url_state = require("../../../../utils/use_url_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_QUERY = {
  language: 'kuery',
  query: ''
};
const LogsQueryStateRT = rt.type({
  language: rt.string,
  query: rt.any
});
const encodeUrlState = LogsQueryStateRT.encode;
const decodeUrlState = defaultValue => value => {
  return (0, _pipeable.pipe)(LogsQueryStateRT.decode(value), (0, _Either.fold)((0, _function.constant)(defaultValue), _function.identity));
};
const useLogsSearchUrlState = () => {
  return (0, _use_url_state.useUrlState)({
    defaultState: DEFAULT_QUERY,
    decodeUrlState: decodeUrlState(DEFAULT_QUERY),
    encodeUrlState,
    urlStateKey: 'logsQuery'
  });
};
exports.useLogsSearchUrlState = useLogsSearchUrlState;