"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHostsViewContext = exports.useHostsView = exports.HostsViewProvider = exports.HostsView = void 0;
var _react = require("react");
var _constate = _interopRequireDefault(require("constate"));
var _useAsyncFn = _interopRequireDefault(require("react-use/lib/useAsyncFn"));
var _use_kibana = require("../../../../hooks/use_kibana");
var _metrics_source = require("../../../../containers/metrics_source");
var _use_unified_search = require("./use_unified_search");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HOST_TABLE_METRICS = [{
  type: 'rx'
}, {
  type: 'tx'
}, {
  type: 'memory'
}, {
  type: 'cpu'
}, {
  type: 'diskLatency'
}, {
  type: 'memoryTotal'
}];
const BASE_INFRA_METRICS_PATH = '/api/metrics/infra';
const useHostsView = () => {
  var _value$nodes;
  const {
    sourceId
  } = (0, _metrics_source.useSourceContext)();
  const {
    services: {
      http
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    buildQuery,
    getParsedDateRange,
    searchCriteria
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const abortCtrlRef = (0, _react.useRef)(new AbortController());
  const baseRequest = (0, _react.useMemo)(() => createInfraMetricsRequest({
    dateRange: getParsedDateRange(),
    esQuery: buildQuery(),
    sourceId,
    limit: searchCriteria.limit
  }), [buildQuery, getParsedDateRange, sourceId, searchCriteria.limit]);
  const [state, refetch] = (0, _useAsyncFn.default)(() => {
    abortCtrlRef.current.abort();
    abortCtrlRef.current = new AbortController();
    return http.post(`${BASE_INFRA_METRICS_PATH}`, {
      signal: abortCtrlRef.current.signal,
      body: JSON.stringify(baseRequest)
    });
  }, [baseRequest, http], {
    loading: true
  });
  (0, _react.useEffect)(() => {
    refetch();
  }, [refetch]);
  const {
    value,
    error,
    loading
  } = state;
  return {
    requestTs: baseRequest.requestTs,
    loading,
    error,
    hostNodes: (_value$nodes = value === null || value === void 0 ? void 0 : value.nodes) !== null && _value$nodes !== void 0 ? _value$nodes : []
  };
};
exports.useHostsView = useHostsView;
const HostsView = (0, _constate.default)(useHostsView);
exports.HostsView = HostsView;
const [HostsViewProvider, useHostsViewContext] = HostsView;

/**
 * Helpers
 */
exports.useHostsViewContext = useHostsViewContext;
exports.HostsViewProvider = HostsViewProvider;
const createInfraMetricsRequest = ({
  esQuery,
  sourceId,
  dateRange,
  limit
}) => ({
  type: 'host',
  query: esQuery,
  range: {
    from: dateRange.from,
    to: dateRange.to
  },
  metrics: HOST_TABLE_METRICS,
  limit,
  sourceId,
  requestTs: Date.now()
});