"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHostsTableContext = exports.useHostsTable = exports.HostsTableProvider = exports.HostsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constate = _interopRequireDefault(require("constate"));
var _lodash = require("lodash");
var _fp = require("lodash/fp");
var _use_kibana = require("../../../../hooks/use_kibana");
var _create_inventory_metric_formatter = require("../../inventory_view/lib/create_inventory_metric_formatter");
var _hosts_table_entry_title = require("../components/hosts_table_entry_title");
var _use_host_flyout_open_url_state = require("./use_host_flyout_open_url_state");
var _use_hosts_table_url_state = require("./use_hosts_table_url_state");
var _use_hosts_view = require("./use_hosts_view");
var _use_unified_search = require("./use_unified_search");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Helper functions
 */
const formatMetric = (type, value) => {
  return value || value === 0 ? (0, _create_inventory_metric_formatter.createInventoryMetricFormatter)({
    type
  })(value) : 'N/A';
};
const buildItemsList = nodes => {
  return nodes.map(({
    metrics,
    metadata,
    name
  }) => {
    var _metadataKeyValue$hos, _ref, _metadataKeyValue$hos2, _metadataKeyValue$hos3;
    const metadataKeyValue = metadata.reduce((acc, curr) => ({
      ...acc,
      [curr.name]: curr.value
    }), {});
    return {
      name,
      id: `${name}-${(_metadataKeyValue$hos = metadataKeyValue['host.os.name']) !== null && _metadataKeyValue$hos !== void 0 ? _metadataKeyValue$hos : '-'}`,
      title: {
        name,
        cloudProvider: (_ref = metadataKeyValue['cloud.provider']) !== null && _ref !== void 0 ? _ref : null
      },
      os: (_metadataKeyValue$hos2 = metadataKeyValue['host.os.name']) !== null && _metadataKeyValue$hos2 !== void 0 ? _metadataKeyValue$hos2 : '-',
      ip: (_metadataKeyValue$hos3 = metadataKeyValue['host.ip']) !== null && _metadataKeyValue$hos3 !== void 0 ? _metadataKeyValue$hos3 : '',
      ...metrics.reduce((acc, curr) => {
        var _curr$value;
        return {
          ...acc,
          [curr.name]: (_curr$value = curr.value) !== null && _curr$value !== void 0 ? _curr$value : 0
        };
      }, {})
    };
  });
};
const isTitleColumn = cell => {
  return typeof cell === 'object' && cell && 'name' in cell;
};
const sortValues = (aValue, bValue, {
  direction
}) => {
  if (typeof aValue === 'string' && typeof bValue === 'string') {
    return direction === 'desc' ? bValue.localeCompare(aValue) : aValue.localeCompare(bValue);
  }
  if ((0, _fp.isNumber)(aValue) && (0, _fp.isNumber)(bValue)) {
    return direction === 'desc' ? bValue - aValue : aValue - bValue;
  }
  return 1;
};
const sortTableData = ({
  direction,
  field
}) => (a, b) => {
  const aValue = a[field];
  const bValue = b[field];
  if (isTitleColumn(aValue) && isTitleColumn(bValue)) {
    return sortValues(aValue.name, bValue.name, {
      direction,
      field
    });
  }
  return sortValues(aValue, bValue, {
    direction,
    field
  });
};

/**
 * Columns translations
 */
const titleLabel = _i18n.i18n.translate('xpack.infra.hostsViewPage.table.nameColumnHeader', {
  defaultMessage: 'Name'
});
const osLabel = _i18n.i18n.translate('xpack.infra.hostsViewPage.table.operatingSystemColumnHeader', {
  defaultMessage: 'Operating System'
});
const averageCpuUsageLabel = _i18n.i18n.translate('xpack.infra.hostsViewPage.table.averageCpuUsageColumnHeader', {
  defaultMessage: 'CPU usage (avg.)'
});
const diskLatencyLabel = _i18n.i18n.translate('xpack.infra.hostsViewPage.table.diskLatencyColumnHeader', {
  defaultMessage: 'Disk Latency (avg.)'
});
const averageTXLabel = _i18n.i18n.translate('xpack.infra.hostsViewPage.table.averageTxColumnHeader', {
  defaultMessage: 'TX (avg.)'
});
const averageRXLabel = _i18n.i18n.translate('xpack.infra.hostsViewPage.table.averageRxColumnHeader', {
  defaultMessage: 'RX (avg.)'
});
const averageTotalMemoryLabel = _i18n.i18n.translate('xpack.infra.hostsViewPage.table.averageMemoryTotalColumnHeader', {
  defaultMessage: 'Memory total (avg.)'
});
const averageMemoryUsageLabel = _i18n.i18n.translate('xpack.infra.hostsViewPage.table.averageMemoryUsageColumnHeader', {
  defaultMessage: 'Memory usage (avg.)'
});
const toggleDialogActionLabel = _i18n.i18n.translate('xpack.infra.hostsViewPage.table.toggleDialogWithDetails', {
  defaultMessage: 'Toggle dialog with details'
});

/**
 * Build a table columns and items starting from the snapshot nodes.
 */
const useHostsTable = () => {
  const {
    hostNodes
  } = (0, _use_hosts_view.useHostsViewContext)();
  const {
    searchCriteria
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const [{
    pagination,
    sorting
  }, setProperties] = (0, _use_hosts_table_url_state.useHostsTableUrlState)();
  const {
    services: {
      telemetry
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const [hostFlyoutOpen, setHostFlyoutOpen, setFlyoutClosed] = (0, _use_host_flyout_open_url_state.useHostFlyoutOpen)();
  const closeFlyout = () => setFlyoutClosed();
  const reportHostEntryClick = (0, _react.useCallback)(({
    name,
    cloudProvider
  }) => {
    telemetry.reportHostEntryClicked({
      hostname: name,
      cloud_provider: cloudProvider
    });
  }, [telemetry]);
  const onTableChange = (0, _react.useCallback)(({
    page,
    sort
  }) => {
    const {
      index: pageIndex,
      size: pageSize
    } = page;
    const {
      field,
      direction
    } = sort !== null && sort !== void 0 ? sort : {};
    const currentSorting = {
      field: field,
      direction
    };
    const currentPagination = {
      pageIndex,
      pageSize
    };
    if (!(0, _lodash.isEqual)(sorting, currentSorting)) {
      setProperties({
        sorting: currentSorting
      });
    } else if (!(0, _lodash.isEqual)(pagination, currentPagination)) {
      setProperties({
        pagination: currentPagination
      });
    }
  }, [setProperties, pagination, sorting]);
  const items = (0, _react.useMemo)(() => buildItemsList(hostNodes), [hostNodes]);
  const clickedItem = (0, _react.useMemo)(() => items.find(({
    id
  }) => id === hostFlyoutOpen.clickedItemId), [hostFlyoutOpen.clickedItemId, items]);
  const currentPage = (0, _react.useMemo)(() => {
    const {
      pageSize = 0,
      pageIndex = 0
    } = pagination;
    const endIndex = (pageIndex + 1) * pageSize;
    const startIndex = pageIndex * pageSize;
    return items.sort(sortTableData(sorting)).slice(startIndex, endIndex);
  }, [items, pagination, sorting]);
  const columns = (0, _react.useMemo)(() => [{
    name: '',
    width: '40px',
    field: 'id',
    actions: [{
      name: toggleDialogActionLabel,
      description: toggleDialogActionLabel,
      icon: ({
        id
      }) => hostFlyoutOpen.clickedItemId && id === hostFlyoutOpen.clickedItemId ? 'minimize' : 'expand',
      type: 'icon',
      'data-test-subj': 'hostsView-flyout-button',
      onClick: ({
        id
      }) => {
        setHostFlyoutOpen({
          clickedItemId: id
        });
        if (id === hostFlyoutOpen.clickedItemId) {
          setFlyoutClosed();
        } else {
          setHostFlyoutOpen({
            clickedItemId: id
          });
        }
      }
    }]
  }, {
    name: titleLabel,
    field: 'title',
    sortable: true,
    truncateText: true,
    'data-test-subj': 'hostsView-tableRow-title',
    render: title => /*#__PURE__*/_react.default.createElement(_hosts_table_entry_title.HostsTableEntryTitle, {
      title: title,
      time: searchCriteria.dateRange,
      onClick: () => reportHostEntryClick(title)
    })
  }, {
    name: osLabel,
    field: 'os',
    sortable: true,
    'data-test-subj': 'hostsView-tableRow-os',
    render: os => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, os)
  }, {
    name: averageCpuUsageLabel,
    field: 'cpu',
    sortable: true,
    'data-test-subj': 'hostsView-tableRow-cpuUsage',
    render: avg => formatMetric('cpu', avg),
    align: 'right'
  }, {
    name: diskLatencyLabel,
    field: 'diskLatency',
    sortable: true,
    'data-test-subj': 'hostsView-tableRow-diskLatency',
    render: avg => formatMetric('diskLatency', avg),
    align: 'right'
  }, {
    name: averageRXLabel,
    field: 'rx',
    sortable: true,
    'data-test-subj': 'hostsView-tableRow-rx',
    render: avg => formatMetric('rx', avg),
    align: 'right'
  }, {
    name: averageTXLabel,
    field: 'tx',
    sortable: true,
    'data-test-subj': 'hostsView-tableRow-tx',
    render: avg => formatMetric('tx', avg),
    align: 'right'
  }, {
    name: averageTotalMemoryLabel,
    field: 'memoryTotal',
    sortable: true,
    'data-test-subj': 'hostsView-tableRow-memoryTotal',
    render: avg => formatMetric('memoryTotal', avg),
    align: 'right'
  }, {
    name: averageMemoryUsageLabel,
    field: 'memory',
    sortable: true,
    'data-test-subj': 'hostsView-tableRow-memory',
    render: avg => formatMetric('memory', avg),
    align: 'right'
  }], [hostFlyoutOpen.clickedItemId, reportHostEntryClick, searchCriteria.dateRange, setFlyoutClosed, setHostFlyoutOpen]);
  return {
    columns,
    clickedItem,
    currentPage,
    closeFlyout,
    items,
    isFlyoutOpen: !!hostFlyoutOpen.clickedItemId,
    onTableChange,
    pagination,
    sorting
  };
};
exports.useHostsTable = useHostsTable;
const HostsTable = (0, _constate.default)(useHostsTable);
exports.HostsTable = HostsTable;
const [HostsTableProvider, useHostsTableContext] = HostsTable;
exports.useHostsTableContext = useHostsTableContext;
exports.HostsTableProvider = HostsTableProvider;