"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHostFlyoutOpen = exports.GET_DEFAULT_TABLE_PROPERTIES = exports.FlyoutTabIds = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _pipeable = require("fp-ts/lib/pipeable");
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _use_url_state = require("../../../../utils/use_url_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let FlyoutTabIds;
exports.FlyoutTabIds = FlyoutTabIds;
(function (FlyoutTabIds) {
  FlyoutTabIds["METADATA"] = "metadata";
  FlyoutTabIds["PROCESSES"] = "processes";
})(FlyoutTabIds || (exports.FlyoutTabIds = FlyoutTabIds = {}));
const GET_DEFAULT_TABLE_PROPERTIES = {
  clickedItemId: '',
  selectedTabId: FlyoutTabIds.METADATA,
  searchFilter: '',
  metadataSearch: ''
};
exports.GET_DEFAULT_TABLE_PROPERTIES = GET_DEFAULT_TABLE_PROPERTIES;
const HOST_TABLE_PROPERTIES_URL_STATE_KEY = 'hostFlyoutOpen';
const useHostFlyoutOpen = () => {
  const [urlState, setUrlState] = (0, _use_url_state.useUrlState)({
    defaultState: '',
    decodeUrlState,
    encodeUrlState,
    urlStateKey: HOST_TABLE_PROPERTIES_URL_STATE_KEY
  });
  const setHostFlyoutOpen = newProps => typeof urlState !== 'string' ? setUrlState({
    ...urlState,
    ...newProps
  }) : setUrlState({
    ...GET_DEFAULT_TABLE_PROPERTIES,
    ...newProps
  });
  const setFlyoutClosed = () => setUrlState('');
  return [urlState, setHostFlyoutOpen, setFlyoutClosed];
};
exports.useHostFlyoutOpen = useHostFlyoutOpen;
const FlyoutTabIdRT = rt.union([rt.literal('metadata'), rt.literal('processes')]);
const ClickedItemIdRT = rt.string;
const SearchFilterRT = rt.string;
const SetFlyoutTabId = rt.partial({
  selectedTabId: FlyoutTabIdRT
});
const SetClickedItemIdRT = rt.partial({
  clickedItemId: ClickedItemIdRT
});
const SetSearchFilterRT = rt.partial({
  searchFilter: SearchFilterRT
});
const SetMetadataSearchRT = rt.partial({
  metadataSearch: SearchFilterRT
});
const ActionRT = rt.intersection([SetClickedItemIdRT, SetFlyoutTabId, SetSearchFilterRT, SetMetadataSearchRT]);
const HostFlyoutOpenRT = rt.type({
  clickedItemId: ClickedItemIdRT,
  selectedTabId: FlyoutTabIdRT,
  searchFilter: SearchFilterRT,
  metadataSearch: SearchFilterRT
});
const HostFlyoutUrlRT = rt.union([HostFlyoutOpenRT, rt.string]);
const encodeUrlState = HostFlyoutUrlRT.encode;
const decodeUrlState = value => {
  return (0, _pipeable.pipe)(HostFlyoutUrlRT.decode(value), (0, _Either.fold)((0, _function.constant)('undefined'), _function.identity));
};