"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMetricsDataViewContext = exports.useDataView = exports.generateDataViewId = exports.MetricsDataViewProvider = exports.MetricsDataView = void 0;
var _uuid = require("uuid");
var _constate = _interopRequireDefault(require("constate"));
var _useAsyncRetry = _interopRequireDefault(require("react-use/lib/useAsyncRetry"));
var _use_kibana = require("../../../../hooks/use_kibana");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateDataViewId = indexPattern => {
  // generates a unique but the same uuid as long as the index pattern doesn't change
  return `${_constants.DATA_VIEW_PREFIX}_${(0, _uuid.v5)(indexPattern, _uuid.v5.DNS)}`;
};
exports.generateDataViewId = generateDataViewId;
const useDataView = ({
  metricAlias
}) => {
  const {
    services: {
      dataViews
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const state = (0, _useAsyncRetry.default)(() => {
    return dataViews.create({
      id: generateDataViewId(metricAlias),
      title: metricAlias,
      timeFieldName: _constants.TIMESTAMP_FIELD
    });
  }, [metricAlias]);
  const {
    value,
    loading,
    error,
    retry
  } = state;
  return {
    metricAlias,
    dataView: value,
    loading,
    loadDataView: retry,
    error
  };
};
exports.useDataView = useDataView;
const MetricsDataView = (0, _constate.default)(useDataView);
exports.MetricsDataView = MetricsDataView;
const [MetricsDataViewProvider, useMetricsDataViewContext] = MetricsDataView;
exports.useMetricsDataViewContext = useMetricsDataViewContext;
exports.MetricsDataViewProvider = MetricsDataViewProvider;