"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertsQueryImpl = exports.useAlertsQuery = exports.AlertsQueryProvider = exports.AlertsQueryContainer = void 0;
var _react = require("react");
var _constate = _interopRequireDefault(require("constate"));
var _common = require("@kbn/data-plugin/common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _esQuery = require("@kbn/es-query");
var _use_unified_search = require("./use_unified_search");
var _use_hosts_view = require("./use_hosts_view");
var _constants = require("../constants");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAlertsQueryImpl = () => {
  const {
    hostNodes
  } = (0, _use_hosts_view.useHostsViewContext)();
  const {
    searchCriteria
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const [alertStatus, setAlertStatus] = (0, _react.useState)('all');
  const getAlertsEsQuery = (0, _react.useCallback)(status => createAlertsEsQuery({
    dateRange: searchCriteria.dateRange,
    hostNodes,
    status
  }), [hostNodes, searchCriteria.dateRange]);

  // Regenerate the query when status change even if is not used.
  // eslint-disable-next-line react-hooks/exhaustive-deps
  const alertsEsQuery = (0, _react.useMemo)(() => getAlertsEsQuery(), [getAlertsEsQuery, alertStatus]);
  const alertsEsQueryByStatus = (0, _react.useMemo)(() => getAlertsEsQuery(alertStatus), [getAlertsEsQuery, alertStatus]);
  return {
    alertStatus,
    setAlertStatus,
    alertsEsQuery,
    alertsEsQueryByStatus
  };
};
exports.useAlertsQueryImpl = useAlertsQueryImpl;
const AlertsQueryContainer = (0, _constate.default)(useAlertsQueryImpl);
exports.AlertsQueryContainer = AlertsQueryContainer;
const [AlertsQueryProvider, useAlertsQuery] = AlertsQueryContainer;

/**
 * Helpers
 */
exports.useAlertsQuery = useAlertsQuery;
exports.AlertsQueryProvider = AlertsQueryProvider;
const createAlertsEsQuery = ({
  dateRange,
  hostNodes,
  status
}) => {
  const alertStatusFilter = createAlertStatusFilter(status);
  const dateFilter = createDateFilter(dateRange);
  const hostsFilter = (0, _utils.createHostsFilter)(hostNodes.map(p => p.name));
  const filters = [alertStatusFilter, dateFilter, hostsFilter].filter(Boolean);
  return (0, _esQuery.buildEsQuery)(undefined, [], filters);
};
const createDateFilter = date => (0, _common.getTime)(undefined, date, {
  fieldName: _ruleDataUtils.ALERT_TIME_RANGE
});
const createAlertStatusFilter = (status = 'all') => _constants.ALERT_STATUS_QUERY[status] ? {
  query: _constants.ALERT_STATUS_QUERY[status],
  meta: {}
} : null;