"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsGrid = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _metric_chart = require("./metric_chart");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_BREAKDOWN_SIZE = 20;
const CHARTS_IN_ORDER = [{
  title: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.metricsCharts.load', {
    defaultMessage: 'Normalized Load'
  }),
  type: 'load'
}, {
  title: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.metricsCharts.cpu', {
    defaultMessage: 'CPU Usage'
  }),
  type: 'cpu'
}, {
  title: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.metricsCharts.memory', {
    defaultMessage: 'Memory Usage'
  }),
  type: 'memory'
}, {
  title: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.metricsCharts.memoryAvailable', {
    defaultMessage: 'Memory Available'
  }),
  type: 'memoryAvailable'
}, {
  title: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.metricsCharts.rx', {
    defaultMessage: 'Network Inbound (RX)'
  }),
  type: 'rx'
}, {
  title: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.metricsCharts.tx', {
    defaultMessage: 'Network Outbound (TX)'
  }),
  type: 'tx'
}, {
  title: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.metricsCharts.diskIORead', {
    defaultMessage: 'Disk Read IOPS'
  }),
  type: 'diskIORead'
}, {
  title: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.metricsCharts.DiskIOWrite', {
    defaultMessage: 'Disk Write IOPS'
  }),
  type: 'diskIOWrite'
}];
const MetricsGrid = /*#__PURE__*/_react.default.memo(() => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "s",
    "data-test-subj": "hostsView-metricChart"
  }, CHARTS_IN_ORDER.map(({
    fullRow,
    ...chartProp
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: chartProp.type,
    style: fullRow ? {
      gridColumn: '1/-1'
    } : {}
  }, /*#__PURE__*/_react.default.createElement(_metric_chart.MetricChart, (0, _extends2.default)({
    breakdownSize: DEFAULT_BREAKDOWN_SIZE
  }, chartProp)))));
});
exports.MetricsGrid = MetricsGrid;