"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsSearchBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_logs_search_url_state = require("../../../hooks/use_logs_search_url_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const debounceIntervalInMs = 1000;
const LogsSearchBar = () => {
  const [filterQuery, setFilterQuery] = (0, _use_logs_search_url_state.useLogsSearchUrlState)();
  const [searchText, setSearchText] = (0, _react.useState)(filterQuery.query);
  const onQueryChange = (0, _react.useCallback)(e => {
    setSearchText(e.target.value);
  }, []);
  (0, _useDebounce.default)(() => setFilterQuery({
    ...filterQuery,
    query: searchText
  }), debounceIntervalInMs, [searchText]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "hostsView-logs-text-field-search",
    fullWidth: true,
    isClearable: true,
    placeholder: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.logs.textFieldPlaceholder', {
      defaultMessage: 'Search for log entries...'
    }),
    onChange: onQueryChange,
    value: searchText
  });
};
exports.LogsSearchBar = LogsSearchBar;