"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsLinkToStream = void 0;
var _react = _interopRequireDefault(require("react"));
var _querystring = require("querystring");
var _rison = require("@kbn/rison");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_kibana = require("../../../../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogsLinkToStream = ({
  startTimestamp,
  endTimestamp,
  query
}) => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    http
  } = services;
  const queryString = new URLSearchParams((0, _querystring.stringify)({
    logPosition: (0, _rison.encode)({
      start: new Date(startTimestamp),
      end: new Date(endTimestamp),
      streamLive: false
    }),
    logFilter: (0, _rison.encode)({
      kind: 'kuery',
      expression: query
    })
  }));
  const viewInLogsUrl = http.basePath.prepend(`/app/logs/stream?${queryString}`);
  return /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: services
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    href: viewInLogsUrl,
    "data-test-subj": "hostsView-logs-link-to-stream-button",
    iconType: "popout",
    flush: "both"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.hostsViewPage.tabs.logs.openInLogsUiLinkText",
    defaultMessage: "Open in Logs"
  })));
};
exports.LogsLinkToStream = LogsLinkToStream;