"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LimitOptions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LimitOptions = ({
  limit,
  onChange
}) => {
  const [idSelected, setIdSelected] = (0, _react.useState)(limit);
  const onSelected = (_id, value) => {
    setIdSelected(value);
    onChange(value);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    justifyContent: "spaceBetween",
    responsive: false,
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    textAlign: "left"
  }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.hostsViewPage.hostLimit",
    defaultMessage: "Host limit"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    className: "eui-fullWidth",
    delay: "regular",
    content: _i18n.i18n.translate('xpack.infra.hostsViewPage.hostLimit.tooltip', {
      defaultMessage: 'To ensure faster query performance, there is a limit to the number of hosts returned'
    }),
    anchorClassName: "eui-fullWidth"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "iInCircle",
    size: "m"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    type: "single",
    legend: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.alerts.alertStatusFilter.legend', {
      defaultMessage: 'Filter by'
    }),
    idSelected: buildId(idSelected),
    options: options,
    onChange: onSelected
  })));
};
exports.LimitOptions = LimitOptions;
const buildId = option => `hostLimit_${option}`;
const options = _constants.HOST_LIMIT_OPTIONS.map(option => ({
  id: buildId(option),
  label: `${option}`,
  value: option,
  'data-test-subj': `hostsViewLimitSelection${option}Button`
}));