"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KPIGrid = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _tile = require("./tile");
var _use_host_count = require("../../hooks/use_host_count");
var _hosts_tile = require("./hosts_tile");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KPI_CHARTS = [{
  type: 'cpu',
  trendLine: true,
  backgroundColor: '#F1D86F',
  title: _i18n.i18n.translate('xpack.infra.hostsViewPage.metricTrend.cpu.title', {
    defaultMessage: 'CPU usage'
  }),
  toolTip: _i18n.i18n.translate('xpack.infra.hostsViewPage.metricTrend.cpu.tooltip', {
    defaultMessage: 'Average of percentage of CPU time spent in states other than Idle and IOWait, normalized by the number of CPU cores. Includes both time spent on user space and kernel space. 100% means all CPUs of the host are busy.'
  })
}, {
  type: 'memory',
  trendLine: true,
  backgroundColor: '#A987D1',
  title: _i18n.i18n.translate('xpack.infra.hostsViewPage.metricTrend.memory.title', {
    defaultMessage: 'Memory usage'
  }),
  toolTip: _i18n.i18n.translate('xpack.infra.hostsViewPage.metricTrend.memory.tooltip', {
    defaultMessage: "Average of percentage of main memory usage excluding page cache. This includes resident memory for all processes plus memory used by the kernel structures and code apart the page cache. A high level indicates a situation of memory saturation for a host. 100% means the main memory is entirely filled with memory that can't be reclaimed, except by swapping out."
  })
}, {
  type: 'rx',
  trendLine: true,
  backgroundColor: '#79AAD9',
  title: _i18n.i18n.translate('xpack.infra.hostsViewPage.metricTrend.rx.title', {
    defaultMessage: 'Network inbound (RX)'
  }),
  toolTip: _i18n.i18n.translate('xpack.infra.hostsViewPage.metricTrend.rx.tooltip', {
    defaultMessage: 'Number of bytes which have been received per second on the public interfaces of the hosts.'
  })
}, {
  type: 'tx',
  trendLine: true,
  backgroundColor: '#F5A35C',
  title: _i18n.i18n.translate('xpack.infra.hostsViewPage.metricTrend.tx.title', {
    defaultMessage: 'Network outbound (TX)'
  }),
  toolTip: _i18n.i18n.translate('xpack.infra.hostsViewPage.metricTrend.tx.tooltip', {
    defaultMessage: 'Number of bytes which have been received per second on the public interfaces of the hosts.'
  })
}];
const KPIGrid = () => {
  return /*#__PURE__*/_react.default.createElement(_use_host_count.HostCountProvider, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    style: {
      flexGrow: 0
    },
    "data-test-subj": "hostsViewKPIGrid"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hosts_tile.HostsTile, null)), KPI_CHARTS.map(({
    ...chartProp
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: chartProp.type
  }, /*#__PURE__*/_react.default.createElement(_tile.Tile, chartProp)))));
};
exports.KPIGrid = KPIGrid;