"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostsTile = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_host_count = require("../../hooks/use_host_count");
var _use_unified_search = require("../../hooks/use_unified_search");
var _metric_chart_wrapper = require("../chart/metric_chart_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HOSTS_CHART = {
  id: `metric-hostCount`,
  color: '#6DCCB1',
  title: _i18n.i18n.translate('xpack.infra.hostsViewPage.metricTrend.hostCount.title', {
    defaultMessage: 'Hosts'
  }),
  toolTip: _i18n.i18n.translate('xpack.infra.hostsViewPage.metricTrend.hostCount.tooltip', {
    defaultMessage: 'The number of hosts returned by your current search criteria.'
  }),
  ['data-test-subj']: 'hostsViewKPI-hostsCount'
};
const HostsTile = () => {
  var _hostCountData$count$2;
  const {
    data: hostCountData,
    isRequestRunning: hostCountLoading
  } = (0, _use_host_count.useHostCountContext)();
  const {
    searchCriteria
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const getSubtitle = () => {
    var _hostCountData$count$;
    return searchCriteria.limit < ((_hostCountData$count$ = hostCountData === null || hostCountData === void 0 ? void 0 : hostCountData.count.value) !== null && _hostCountData$count$ !== void 0 ? _hostCountData$count$ : 0) ? _i18n.i18n.translate('xpack.infra.hostsViewPage.metricTrend.subtitle.hostCount.limit', {
      defaultMessage: 'Limited to {limit}',
      values: {
        limit: searchCriteria.limit
      }
    }) : undefined;
  };
  return /*#__PURE__*/_react.default.createElement(_metric_chart_wrapper.MetricChartWrapper, (0, _extends2.default)({}, HOSTS_CHART, {
    value: (_hostCountData$count$2 = hostCountData === null || hostCountData === void 0 ? void 0 : hostCountData.count.value) !== null && _hostCountData$count$2 !== void 0 ? _hostCountData$count$2 : 0,
    subtitle: getSubtitle(),
    loading: hostCountLoading
  }));
};
exports.HostsTile = HostsTile;