"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostsTableEntryTitle = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-plugin/public");
var _rison = require("@kbn/rison");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cloudIcons = {
  gcp: 'logoGCP',
  aws: 'logoAWS',
  azure: 'logoAzure',
  unknownProvider: 'cloudSunny'
};
const HostsTableEntryTitle = ({
  onClick,
  time,
  title
}) => {
  const {
    name,
    cloudProvider
  } = title;
  const link = (0, _public.useLinkProps)({
    app: 'metrics',
    pathname: `/detail/host/${name}`,
    search: {
      _a: (0, _rison.encode)({
        time: {
          ...time,
          interval: '>=1m'
        }
      })
    }
  });
  const iconType = cloudProvider && cloudIcons[cloudProvider] || cloudIcons.unknownProvider;
  const providerName = cloudProvider !== null && cloudProvider !== void 0 ? cloudProvider : 'Unknown';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    className: "eui-textTruncate",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    delay: "long",
    content: providerName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: iconType,
    size: "m",
    title: name
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "eui-textTruncate",
    onClick: onClick
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    delay: "long",
    content: name
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
    "data-test-subj": "infraHostsTableEntryTitleLink",
    className: "eui-displayBlock eui-textTruncate"
  }, link), name))));
};
exports.HostsTableEntryTitle = HostsTableEntryTitle;