"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostsTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _empty_states = require("../../../../components/empty_states");
var _use_hosts_table = require("../hooks/use_hosts_table");
var _use_hosts_view = require("../hooks/use_hosts_view");
var _use_unified_search = require("../hooks/use_unified_search");
var _flyout = require("./host_details_flyout/flyout");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PAGE_SIZE_OPTIONS = [5, 10, 20];
const HostsTable = () => {
  var _pagination$pageIndex, _pagination$pageSize, _sorting$direction;
  const {
    loading
  } = (0, _use_hosts_view.useHostsViewContext)();
  const {
    onSubmit
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const {
    columns,
    items,
    currentPage,
    isFlyoutOpen,
    closeFlyout,
    clickedItem,
    onTableChange,
    pagination,
    sorting
  } = (0, _use_hosts_table.useHostsTableContext)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "hostsView-table",
    pagination: {
      pageIndex: (_pagination$pageIndex = pagination.pageIndex) !== null && _pagination$pageIndex !== void 0 ? _pagination$pageIndex : 0,
      pageSize: (_pagination$pageSize = pagination.pageSize) !== null && _pagination$pageSize !== void 0 ? _pagination$pageSize : _constants.DEFAULT_PAGE_SIZE,
      totalItemCount: items.length,
      pageSizeOptions: PAGE_SIZE_OPTIONS
    },
    sorting: {
      sort: {
        field: sorting.field,
        direction: (_sorting$direction = sorting.direction) !== null && _sorting$direction !== void 0 ? _sorting$direction : 'asc'
      }
    },
    rowProps: {
      'data-test-subj': 'hostsView-tableRow'
    },
    items: currentPage,
    columns: columns,
    loading: loading,
    onChange: onTableChange,
    noItemsMessage: loading ? _i18n.i18n.translate('xpack.infra.waffle.loadingDataText', {
      defaultMessage: 'Loading data'
    }) : /*#__PURE__*/_react.default.createElement(_empty_states.NoData, {
      titleText: _i18n.i18n.translate('xpack.infra.waffle.noDataTitle', {
        defaultMessage: 'There is no data to display.'
      }),
      bodyText: _i18n.i18n.translate('xpack.infra.waffle.noDataDescription', {
        defaultMessage: 'Try adjusting your time or filter.'
      }),
      refetchText: _i18n.i18n.translate('xpack.infra.waffle.checkNewDataButtonLabel', {
        defaultMessage: 'Check for new data'
      }),
      onRefetch: () => onSubmit(),
      testString: "noMetricsDataPrompt"
    })
  }), isFlyoutOpen && clickedItem && /*#__PURE__*/_react.default.createElement(_flyout.Flyout, {
    node: clickedItem,
    closeFlyout: closeFlyout
  }));
};
exports.HostsTable = HostsTable;