"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostContainer = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _loading = require("../../../../components/loading");
var _use_data_view = require("../hooks/use_data_view");
var _unified_search_bar = require("./search_bar/unified_search_bar");
var _hosts_content = require("./hosts_content");
var _error_callout = require("./error_callout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HostContainer = () => {
  const {
    dataView,
    loading,
    error,
    metricAlias,
    loadDataView
  } = (0, _use_data_view.useMetricsDataViewContext)();
  const isLoading = loading || !dataView;
  if (isLoading && !error) {
    return /*#__PURE__*/_react.default.createElement(_loading.InfraLoadingPanel, {
      height: "100%",
      width: "auto",
      text: _i18n.i18n.translate('xpack.infra.waffle.loadingDataText', {
        defaultMessage: 'Loading data'
      })
    });
  }
  return error ? /*#__PURE__*/_react.default.createElement(_error_callout.ErrorCallout, {
    error: error,
    titleOverride: _i18n.i18n.translate('xpack.infra.hostsViewPage.errorOnCreateOrLoadDataviewTitle', {
      defaultMessage: 'Error creating Data View'
    }),
    messageOverride: _i18n.i18n.translate('xpack.infra.hostsViewPage.errorOnCreateOrLoadDataview', {
      defaultMessage: 'There was an error trying to create a Data View: {metricAlias}. Try reloading the page.',
      values: {
        metricAlias
      }
    }),
    onTryAgainClick: loadDataView,
    hasTryAgainButton: true
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_unified_search_bar.UnifiedSearchBar, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_hosts_content.HostsContent, null));
};
exports.HostContainer = HostContainer;