"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Processes = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _inventory_models = require("../../../../../../../common/inventory_models");
var _parse_search_string = require("../../../../inventory_view/components/node_details/tabs/processes/parse_search_string");
var _processes_table = require("../../../../inventory_view/components/node_details/tabs/processes/processes_table");
var _states = require("../../../../inventory_view/components/node_details/tabs/processes/states");
var _summary_table = require("../../../../inventory_view/components/node_details/tabs/processes/summary_table");
var _shared = require("../../../../inventory_view/components/node_details/tabs/shared");
var _use_process_list = require("../../../../inventory_view/hooks/use_process_list");
var _use_host_flyout_open_url_state = require("../../../hooks/use_host_flyout_open_url_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const options = Object.entries(_states.STATE_NAMES).map(([value, view]) => ({
  value,
  view
}));
const Processes = ({
  currentTime,
  node,
  nodeType
}) => {
  var _ref, _response$processList;
  const [hostFlyoutOpen, setHostFlyoutOpen] = (0, _use_host_flyout_open_url_state.useHostFlyoutOpen)();
  const [searchBarState, setSearchBarState] = (0, _react.useState)(() => hostFlyoutOpen.searchFilter ? _eui.Query.parse(hostFlyoutOpen.searchFilter) : _eui.Query.MATCH_ALL);
  const [sortBy, setSortBy] = (0, _react.useState)({
    name: 'cpu',
    isAscending: false
  });
  const hostTerm = (0, _react.useMemo)(() => {
    var _getFieldByType;
    const field = (_getFieldByType = (0, _inventory_models.getFieldByType)(nodeType)) !== null && _getFieldByType !== void 0 ? _getFieldByType : nodeType;
    return {
      [field]: node.name
    };
  }, [node, nodeType]);
  const {
    loading,
    error,
    response,
    makeRequest: reload
  } = (0, _use_process_list.useProcessList)(hostTerm, currentTime, sortBy, (0, _parse_search_string.parseSearchString)(hostFlyoutOpen.searchFilter));
  const debouncedSearchOnChange = (0, _react.useMemo)(() => (0, _lodash.debounce)(queryText => setHostFlyoutOpen({
    searchFilter: queryText
  }), 500), [setHostFlyoutOpen]);
  const searchBarOnChange = (0, _react.useCallback)(({
    query,
    queryText
  }) => {
    setSearchBarState(query);
    debouncedSearchOnChange(queryText);
  }, [setSearchBarState, debouncedSearchOnChange]);
  const clearSearchBar = (0, _react.useCallback)(() => {
    setSearchBarState(_eui.Query.MATCH_ALL);
    setHostFlyoutOpen({
      searchFilter: ''
    });
  }, [setHostFlyoutOpen]);
  return /*#__PURE__*/_react.default.createElement(_shared.TabContent, null, /*#__PURE__*/_react.default.createElement(_use_process_list.ProcessListContextProvider, {
    hostTerm: hostTerm,
    to: currentTime
  }, /*#__PURE__*/_react.default.createElement(_summary_table.SummaryTable, {
    isLoading: loading,
    processSummary: (_ref = !error ? response === null || response === void 0 ? void 0 : response.summary : null) !== null && _ref !== void 0 ? _ref : {
      total: 0
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processesHeader', {
    defaultMessage: 'Top processes'
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    "aria-label": _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processesHeader.tooltipLabel', {
      defaultMessage: 'More info'
    }),
    size: "m",
    type: "iInCircle",
    content: _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processesHeader.tooltipBody', {
      defaultMessage: 'The table below aggregates the top CPU and top memory consuming processes. It does not display all processes.'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    query: searchBarState,
    onChange: searchBarOnChange,
    box: {
      incremental: true,
      placeholder: _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.searchForProcesses', {
        defaultMessage: 'Search for processes…'
      })
    },
    filters: [{
      type: 'field_value_selection',
      field: 'state',
      name: 'State',
      operator: 'exact',
      multiSelect: false,
      options
    }]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), !error ? /*#__PURE__*/_react.default.createElement(_processes_table.ProcessesTable, {
    currentTime: currentTime,
    isLoading: loading || !response,
    processList: (_response$processList = response === null || response === void 0 ? void 0 : response.processList) !== null && _response$processList !== void 0 ? _response$processList : [],
    sortBy: sortBy,
    setSortBy: setSortBy,
    clearSearchBar: clearSearchBar
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processListError', {
      defaultMessage: 'Unable to load process data'
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "infraTabComponentTryAgainButton",
      color: "primary",
      fill: true,
      onClick: reload
    }, _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processListRetry', {
      defaultMessage: 'Try again'
    }))
  })));
};
exports.Processes = Processes;