"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Table = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _lodash = require("lodash");
var _use_host_flyout_open_url_state = require("../../../hooks/use_host_flyout_open_url_state");
var _add_metadata_filter_button = require("./add_metadata_filter_button");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Columns translations
 */
const FIELD_LABEL = _i18n.i18n.translate('xpack.infra.hostsViewPage.hostDetail.metadata.field', {
  defaultMessage: 'Field'
});
const VALUE_LABEL = _i18n.i18n.translate('xpack.infra.hostsViewPage.hostDetail.metadata.value', {
  defaultMessage: 'Value'
});

/**
 * Component translations
 */
const SEARCH_PLACEHOLDER = _i18n.i18n.translate('xpack.infra.hostsViewPage.hostDetail.metadata.searchForMetadata', {
  defaultMessage: 'Search for metadata…'
});
const NO_METADATA_FOUND = _i18n.i18n.translate('xpack.infra.hostsViewPage.hostDetail.metadata.noMetadataFound', {
  defaultMessage: 'No metadata found.'
});
const LOADING = _i18n.i18n.translate('xpack.infra.hostsViewPage.hostDetail.metadata.loading', {
  defaultMessage: 'Loading...'
});
const Table = props => {
  const {
    rows,
    loading
  } = props;
  const [searchError, setSearchError] = (0, _react.useState)(null);
  const [hostFlyoutOpen, setHostFlyoutOpen] = (0, _use_host_flyout_open_url_state.useHostFlyoutOpen)();
  const debouncedSearchOnChange = (0, _react.useMemo)(() => (0, _lodash.debounce)(queryText => {
    var _String;
    setHostFlyoutOpen({
      metadataSearch: (_String = String(queryText)) !== null && _String !== void 0 ? _String : ''
    });
  }, 500), [setHostFlyoutOpen]);
  const searchBarOnChange = (0, _react.useCallback)(({
    queryText,
    error
  }) => {
    if (error) {
      setSearchError(error);
    } else {
      setSearchError(null);
      debouncedSearchOnChange(queryText);
    }
  }, [debouncedSearchOnChange]);
  const search = {
    onChange: searchBarOnChange,
    box: {
      'data-test-subj': 'infraHostMetadataSearchBarInput',
      incremental: true,
      schema: true,
      placeholder: SEARCH_PLACEHOLDER
    },
    query: hostFlyoutOpen.metadataSearch ? _eui.Query.parse(hostFlyoutOpen.metadataSearch) : _eui.Query.MATCH_ALL
  };
  const columns = (0, _react.useMemo)(() => [{
    field: 'name',
    name: FIELD_LABEL,
    width: '35%',
    sortable: false,
    render: name => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, name)
  }, {
    field: 'value',
    name: VALUE_LABEL,
    width: '55%',
    sortable: false,
    render: (_name, item) => /*#__PURE__*/_react.default.createElement(ExpandableContent, {
      values: item.value
    })
  }, {
    field: 'value',
    name: 'Actions',
    sortable: false,
    showOnHover: true,
    render: (_name, item) => {
      return /*#__PURE__*/_react.default.createElement(_add_metadata_filter_button.AddMetadataFilterButton, {
        item: item
      });
    }
  }], []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    "data-test-subj": "infraMetadataTable",
    tableLayout: 'fixed',
    responsive: false,
    columns: columns,
    items: rows,
    rowProps: {
      className: 'euiTableRow-hasActions'
    },
    search: search,
    loading: loading,
    error: searchError ? `${searchError.message}` : '',
    message: loading ? /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "infraHostMetadataLoading"
    }, LOADING) : /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "infraHostMetadataNoData"
    }, NO_METADATA_FOUND)
  });
};
exports.Table = Table;
const ExpandableContent = props => {
  const {
    values
  } = props;
  const [isExpanded, toggle] = (0, _useToggle.default)(false);
  const list = Array.isArray(values) ? values : [values];
  const [first, ...others] = list;
  const hasOthers = others.length > 0;
  const shouldShowMore = hasOthers && !isExpanded;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 'xs',
    responsive: false,
    alignItems: 'baseline',
    wrap: true,
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement("div", null, first, shouldShowMore && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ' ... ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "infraExpandableContentCountMoreLink",
    onClick: toggle
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.nodeDetails.tabs.metadata.seeMore",
    defaultMessage: "+{count} more",
    values: {
      count: others.length
    }
  })))), isExpanded && others.map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: item
  }, item)), hasOthers && isExpanded && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "infraExpandableContentShowLessLink",
    onClick: toggle
  }, _i18n.i18n.translate('xpack.infra.nodeDetails.tabs.metadata.seeLess', {
    defaultMessage: 'Show less'
  }))));
};