"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Metadata = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _metrics_source = require("../../../../../../containers/metrics_source");
var _inventory_models = require("../../../../../../../common/inventory_models");
var _use_metadata = require("../../../../metric_detail/hooks/use_metadata");
var _table = require("./table");
var _utils = require("./utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Metadata = ({
  node,
  currentTimeRange,
  nodeType
}) => {
  const nodeId = node.name;
  const inventoryModel = (0, _inventory_models.findInventoryModel)(nodeType);
  const {
    sourceId
  } = (0, _metrics_source.useSourceContext)();
  const {
    loading: metadataLoading,
    error: fetchMetadataError,
    metadata
  } = (0, _use_metadata.useMetadata)(nodeId, nodeType, inventoryModel.requiredMetrics, sourceId, currentTimeRange);
  const fields = (0, _react.useMemo)(() => (0, _utils.getAllFields)(metadata), [metadata]);
  if (fetchMetadataError) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.infra.hostsViewPage.hostDetail.metadata.errorTitle', {
        defaultMessage: 'Sorry, there was an error'
      }),
      color: "danger",
      iconType: "error",
      "data-test-subj": "infraMetadataErrorCallout"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.hostsViewPage.hostDetail.metadata.errorMessage",
      defaultMessage: "There was an error loading your data. Try to {reload} and open the host details again.",
      values: {
        reload: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "infraMetadataReloadPageLink",
          onClick: () => window.location.reload()
        }, _i18n.i18n.translate('xpack.infra.hostsViewPage.hostDetail.metadata.errorAction', {
          defaultMessage: 'reload the page'
        }))
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_table.Table, {
    rows: fields,
    loading: metadataLoading
  });
};
exports.Metadata = Metadata;