"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddMetadataFilterButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _build_metadata_filter = require("./build_metadata_filter");
var _use_data_view = require("../../../hooks/use_data_view");
var _use_unified_search = require("../../../hooks/use_unified_search");
var _use_kibana = require("../../../../../../hooks/use_kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const filterAddedToastTitle = _i18n.i18n.translate('xpack.infra.hostsViewPage.flyout.metadata.filterAdded', {
  defaultMessage: 'Filter was added'
});
const AddMetadataFilterButton = ({
  item
}) => {
  const {
    dataView
  } = (0, _use_data_view.useMetricsDataViewContext)();
  const {
    searchCriteria
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const {
    services: {
      data: {
        query: {
          filterManager: filterManagerService
        }
      },
      notifications: {
        toasts: toastsService
      },
      telemetry
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const existingFilter = (0, _react.useMemo)(() => searchCriteria.filters.find(filter => filter.meta.key === item.name), [item.name, searchCriteria.filters]);
  const handleAddFilter = () => {
    var _item$value;
    const newFilter = (0, _build_metadata_filter.buildMetadataFilter)({
      field: item.name,
      value: (_item$value = item.value) !== null && _item$value !== void 0 ? _item$value : '',
      dataView,
      negate: false
    });
    if (newFilter) {
      telemetry.reportHostFlyoutFilterAdded({
        field_name: item.name
      });
      filterManagerService.addFilters(newFilter);
      toastsService.addSuccess({
        title: filterAddedToastTitle,
        toastLifeTimeMs: 10000
      });
    }
  };
  if (existingFilter) {
    return /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.infra.hostsViewPage.flyout.metadata.setRemoveFilterTooltip', {
        defaultMessage: 'Remove filter'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "s",
      color: "text",
      iconType: "filter",
      display: "base",
      "data-test-subj": "hostsView-flyout-metadata-remove-filter",
      "aria-label": _i18n.i18n.translate('xpack.infra.hostsViewPage.flyout.metadata.filterAriaLabel', {
        defaultMessage: 'Filter'
      }),
      onClick: () => {
        telemetry.reportHostFlyoutFilterRemoved({
          field_name: existingFilter.meta.key
        });
        filterManagerService.removeFilter(existingFilter);
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.infra.hostsViewPage.flyout.metadata.setFilterByValueTooltip', {
      defaultMessage: 'Filter by value'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "primary",
    size: "s",
    iconType: "filter",
    "data-test-subj": "hostsView-flyout-metadata-add-filter",
    "aria-label": _i18n.i18n.translate('xpack.infra.hostsViewPage.flyout.metadata.AddFilterAriaLabel', {
      defaultMessage: 'Add Filter'
    }),
    onClick: handleAddFilter
  })));
};
exports.AddMetadataFilterButton = AddMetadataFilterButton;