"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkToApmServices = void 0;
var _react = _interopRequireDefault(require("react"));
var _querystring = require("querystring");
var _rison = require("@kbn/rison");
var _react2 = require("@emotion/react");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_kibana = require("../../../../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LinkToApmServices = ({
  hostName,
  apmField
}) => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    http
  } = services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const queryString = new URLSearchParams((0, _rison.encode)((0, _querystring.stringify)({
    kuery: `${apmField}:"${hostName}"`
  })));
  const linkToApmServices = http.basePath.prepend(`/app/apm/services?${queryString}`);
  return /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: services
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: linkToApmServices,
    "data-test-subj": "hostsView-flyout-apm-services-link"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "popout",
    css: (0, _react2.css)`
            margin-right: ${euiTheme.size.xs};
          `
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.hostsViewPage.flyout.apmServicesLinkLabel",
    defaultMessage: "APM Services"
  })));
};
exports.LinkToApmServices = LinkToApmServices;