"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Flyout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _use_unified_search = require("../../hooks/use_unified_search");
var _link_to_uptime = require("./links/link_to_uptime");
var _link_to_apm_services = require("./links/link_to_apm_services");
var _use_lazy_ref = require("../../../../../hooks/use_lazy_ref");
var _metadata = require("./metadata");
var _processes = require("./processes");
var _metadata2 = require("./metadata/metadata");
var _processes2 = require("./processes/processes");
var _use_host_flyout_open_url_state = require("../../hooks/use_host_flyout_open_url_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const flyoutTabs = [_metadata.metadataTab, _processes.processesTab];
const NODE_TYPE = 'host';
const Flyout = ({
  node,
  closeFlyout
}) => {
  const {
    getDateRangeAsTimestamp
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const currentTimeRange = {
    ...getDateRangeAsTimestamp(),
    interval: '1m'
  };
  const [hostFlyoutOpen, setHostFlyoutOpen] = (0, _use_host_flyout_open_url_state.useHostFlyoutOpen)();

  // This map allow to keep track of which tabs content have been rendered the first time.
  // We need it in order to load a tab content only if it gets clicked, and then keep it in the DOM for performance improvement.
  const renderedTabsSet = (0, _use_lazy_ref.useLazyRef)(() => new Set([hostFlyoutOpen.selectedTabId]));
  const tabEntries = flyoutTabs.map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, (0, _extends2.default)({}, tab, {
    key: tab.id,
    onClick: () => {
      renderedTabsSet.current.add(tab.id); // On a tab click, mark the tab content as allowed to be rendered
      setHostFlyoutOpen({
        selectedTabId: tab.id
      });
    },
    isSelected: tab.id === hostFlyoutOpen.selectedTabId
  }), tab.name));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: closeFlyout,
    ownFocus: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, node.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_link_to_apm_services.LinkToApmServices, {
    hostName: node.name,
    apmField: 'host.hostname'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
              margin-right: ${euiTheme.size.l};
            `
  }, /*#__PURE__*/_react.default.createElement(_link_to_uptime.LinkToUptime, {
    nodeType: NODE_TYPE,
    node: node
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    style: {
      marginBottom: '-25px'
    },
    size: "s"
  }, tabEntries)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, renderedTabsSet.current.has(_use_host_flyout_open_url_state.FlyoutTabIds.METADATA) && /*#__PURE__*/_react.default.createElement("div", {
    hidden: hostFlyoutOpen.selectedTabId !== _use_host_flyout_open_url_state.FlyoutTabIds.METADATA
  }, /*#__PURE__*/_react.default.createElement(_metadata2.Metadata, {
    currentTimeRange: currentTimeRange,
    node: node,
    nodeType: NODE_TYPE
  })), renderedTabsSet.current.has(_use_host_flyout_open_url_state.FlyoutTabIds.PROCESSES) && /*#__PURE__*/_react.default.createElement("div", {
    hidden: hostFlyoutOpen.selectedTabId !== _use_host_flyout_open_url_state.FlyoutTabIds.PROCESSES
  }, /*#__PURE__*/_react.default.createElement(_processes2.Processes, {
    node: node,
    nodeType: NODE_TYPE,
    currentTime: currentTimeRange.to
  }))));
};
exports.Flyout = Flyout;