"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnableHostsViewPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _page_template = require("../../../page_template");
var _hosts_landing_beta_light = _interopRequireDefault(require("./hosts_landing_beta_light.svg"));
var _hosts_landing_beta_dark = _interopRequireDefault(require("./hosts_landing_beta_dark.svg"));
var _experimental_badge = require("../../../../../components/experimental_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnableHostsViewPage = ({
  actions
}) => {
  const backgroundColor = (0, _eui.useEuiBackgroundColor)('subdued');
  const isDarkMode = (0, _public2.useUiSetting)('theme:darkMode');
  (0, _public.useTrackPageview)({
    app: 'infra_metrics',
    path: 'hosts_feature_enable_landing_page'
  });
  (0, _public.useTrackPageview)({
    app: 'infra_metrics',
    path: 'hosts_feature_enable_landing_page',
    delay: 15000
  });
  return /*#__PURE__*/_react.default.createElement(_page_template.MetricsPageTemplate, {
    isEmptyState: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
    "data-test-subj": "hostsLandingPage",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.infra.hostsViewPage.landing.introTitle', {
      defaultMessage: 'Introducing: Host Analysis'
    })),
    alignment: "center",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "fullWidth",
      src: isDarkMode ? _hosts_landing_beta_dark.default : _hosts_landing_beta_light.default,
      alt: "Hosts Landing Page Image"
    }),
    color: "plain",
    layout: "horizontal",
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_experimental_badge.ExperimentalBadge, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.infra.hostsViewPage.landing.introMessage', {
      defaultMessage: `Introducing our new 'Hosts' feature, now available in technical preview!
                With this powerful tool, you can easily view and analyse your hosts and identify any
                issues so you address them quickly. Get a detailed view of metrics for your hosts, see
                which ones are triggering the most alerts and filter the hosts you want to analyse
                using any KQL filter and easy breakdowns such as cloud provider and operating system.`
    })), /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.infra.hostsViewPage.landing.tryTheFeatureMessage', {
      defaultMessage: `This is an early version of the feature and we would love your feedback as we continue
                to develop and improve it. To access the feature, simply enable below. Don't miss
                out on this powerful new addition to our platform - try it out today!`
    }))),
    css: (0, _react2.css)`
          background-color: ${backgroundColor};
        `,
    actions: actions
  }));
};
exports.EnableHostsViewPage = EnableHostsViewPage;