"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageViewLogInContext = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _view_log_in_context = require("../../../containers/logs/view_log_in_context");
var _use_viewport_dimensions = require("../../../utils/use_viewport_dimensions");
var _log_stream = require("../../../components/log_stream");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MODAL_MARGIN = 25;
const PageViewLogInContext = () => {
  const [{
    contextEntry,
    startTimestamp,
    endTimestamp,
    logViewReference
  }, {
    setContextEntry
  }] = (0, _view_log_in_context.useViewLogInProviderContext)();
  const closeModal = (0, _react.useCallback)(() => setContextEntry(undefined), [setContextEntry]);
  const {
    width: vw,
    height: vh
  } = (0, _use_viewport_dimensions.useViewportDimensions)();
  const contextQuery = (0, _react.useMemo)(() => {
    if (contextEntry && !(0, _lodash.isEmpty)(contextEntry.context)) {
      return Object.entries(contextEntry.context).reduce((kuery, [key, value]) => {
        const currentExpression = `${key} : "${value}"`;
        if (kuery.length > 0) {
          return `${kuery} AND ${currentExpression}`;
        } else {
          return currentExpression;
        }
      }, '');
    }
  }, [contextEntry]);
  if (!contextEntry) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: closeModal,
    maxWidth: false
  }, /*#__PURE__*/_react.default.createElement(LogInContextWrapper, {
    width: vw - MODAL_MARGIN * 2,
    height: vh - MODAL_MARGIN * 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    wrap: false,
    style: {
      height: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(LogEntryContext, {
    context: contextEntry.context
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_log_stream.LogStream, {
    logView: logViewReference,
    startTimestamp: startTimestamp,
    endTimestamp: endTimestamp,
    query: contextQuery,
    center: contextEntry.cursor,
    highlight: contextEntry.id,
    height: "100%"
  })))));
};
exports.PageViewLogInContext = PageViewLogInContext;
const LogInContextWrapper = _common.euiStyled.div`
  padding: 16px;
  width: ${props => typeof props.width === 'number' ? `${props.width}px` : props.width};
  height: ${props => typeof props.height === 'number' ? `${props.height}px` : props.height};
  max-height: 75vh; // Same as EuiModal
`;
const LogEntryContext = ({
  context
}) => {
  let text;
  if ('container.id' in context) {
    text = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logs.viewInContext.logsFromContainerTitle",
      defaultMessage: "Displayed logs are from container {container}",
      values: {
        container: context['container.id']
      }
    });
  }
  if ('host.name' in context) {
    const shortenedFilePath = context['log.file.path'].length > 45 ? context['log.file.path'].slice(0, 20) + '...' + context['log.file.path'].slice(-25) : context['log.file.path'];
    text = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logs.viewInContext.logsFromFileTitle",
      defaultMessage: "Displayed logs are from file {file} and host {host}",
      values: {
        file: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: context['log.file.path']
        }, /*#__PURE__*/_react.default.createElement("span", null, shortenedFilePath)),
        host: context['host.name']
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, text)));
};