"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsToolbar = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _log_customization_menu = require("../../../components/logging/log_customization_menu");
var _log_highlights_menu = require("../../../components/logging/log_highlights_menu");
var _log_text_scale_controls = require("../../../components/logging/log_text_scale_controls");
var _log_text_wrap_controls = require("../../../components/logging/log_text_wrap_controls");
var _log_highlights = require("../../../containers/logs/log_highlights/log_highlights");
var _log_position = require("../../../containers/logs/log_position");
var _log_view_configuration = require("../../../containers/logs/log_view_configuration");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_log_view = require("../../../hooks/use_log_view");
var _stream_live_button = require("./components/stream_live_button");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogsToolbar = () => {
  const {
    derivedDataView
  } = (0, _use_log_view.useLogViewContext)();
  const {
    availableTextScales,
    setTextScale,
    setTextWrap,
    textScale,
    textWrap
  } = (0, _log_view_configuration.useLogViewConfigurationContext)();
  const {
    unifiedSearch: {
      ui: {
        SearchBar
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)().services;
  const {
    setHighlightTerms,
    loadLogEntryHighlightsRequest,
    highlightTerms,
    hasPreviousHighlight,
    hasNextHighlight,
    goToPreviousHighlight,
    goToNextHighlight
  } = (0, _log_highlights.useLogHighlightsStateContext)();
  const {
    isStreaming,
    startLiveStreaming,
    stopLiveStreaming
  } = (0, _log_position.useLogPositionStateContext)();
  const dataViews = (0, _react.useMemo)(() => derivedDataView != null ? [derivedDataView] : undefined, [derivedDataView]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(SearchBar, {
    appName: _i18n.i18n.translate('xpack.infra.appName', {
      defaultMessage: 'Infra logs'
    }),
    iconType: "search",
    placeholder: _i18n.i18n.translate('xpack.infra.logsPage.toolbar.kqlSearchFieldPlaceholder', {
      defaultMessage: 'Search for log entries… (e.g. host.name:host-1)'
    }),
    useDefaultBehaviors: true,
    indexPatterns: dataViews,
    showQueryInput: true,
    showQueryMenu: false,
    showFilterBar: true,
    showDatePicker: true,
    displayStyle: "inPage"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "stretch",
    justifyContent: "flexStart",
    direction: "row",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_log_customization_menu.LogCustomizationMenu, null, /*#__PURE__*/_react.default.createElement(_log_text_wrap_controls.LogTextWrapControls, {
    wrap: textWrap,
    setTextWrap: setTextWrap
  }), /*#__PURE__*/_react.default.createElement(_log_text_scale_controls.LogTextScaleControls, {
    availableTextScales: availableTextScales,
    textScale: textScale,
    setTextScale: setTextScale
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_log_highlights_menu.LogHighlightsMenu, {
    onChange: setHighlightTerms,
    isLoading: loadLogEntryHighlightsRequest.state === 'pending',
    activeHighlights: highlightTerms.filter(highlightTerm => highlightTerm.length > 0).length > 0,
    goToPreviousHighlight: goToPreviousHighlight,
    goToNextHighlight: goToNextHighlight,
    hasPreviousHighlight: hasPreviousHighlight,
    hasNextHighlight: hasNextHighlight
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_stream_live_button.StreamLiveButton, {
    isStreaming: isStreaming,
    onStartStreaming: startLiveStreaming,
    onStopStreaming: stopLiveStreaming
  })))));
};
exports.LogsToolbar = LogsToolbar;