"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogStreamPageContentProviders = void 0;
var _jsonStableStringify = _interopRequireDefault(require("json-stable-stringify"));
var _react = _interopRequireWildcard(require("react"));
var _log_flyout = require("../../../containers/logs/log_flyout");
var _log_highlights = require("../../../containers/logs/log_highlights/log_highlights");
var _log_position = require("../../../containers/logs/log_position");
var _log_stream = require("../../../containers/logs/log_stream");
var _log_view_configuration = require("../../../containers/logs/log_view_configuration");
var _view_log_in_context = require("../../../containers/logs/view_log_in_context");
var _use_log_view = require("../../../hooks/use_log_view");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ViewLogInContext = ({
  children
}) => {
  const {
    startTimestamp,
    endTimestamp
  } = (0, _log_position.useLogPositionStateContext)();
  const {
    logViewReference
  } = (0, _use_log_view.useLogViewContext)();
  if (!startTimestamp || !endTimestamp) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_view_log_in_context.ViewLogInContextProvider, {
    startTimestamp: startTimestamp,
    endTimestamp: endTimestamp,
    logViewReference: logViewReference
  }, children);
};
const LogEntriesStateProvider = ({
  children,
  logStreamPageState
}) => {
  const {
    logViewReference
  } = (0, _use_log_view.useLogViewContext)();
  const {
    startTimestamp,
    endTimestamp,
    targetPosition
  } = (0, _log_position.useLogPositionStateContext)();
  const {
    context: {
      parsedQuery
    }
  } = logStreamPageState;

  // Don't render anything if the date range is incorrect.
  if (!startTimestamp || !endTimestamp) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_log_stream.LogStreamProvider, {
    logViewReference: logViewReference,
    startTimestamp: startTimestamp,
    endTimestamp: endTimestamp,
    query: parsedQuery,
    center: targetPosition !== null && targetPosition !== void 0 ? targetPosition : undefined
  }, children);
};
const LogHighlightsState = ({
  children,
  logStreamPageState
}) => {
  const {
    logViewReference,
    logView
  } = (0, _use_log_view.useLogViewContext)();
  const {
    topCursor,
    bottomCursor,
    entries
  } = (0, _log_stream.useLogStreamContext)();
  const serializedParsedQuery = (0, _react.useMemo)(() => (0, _jsonStableStringify.default)(logStreamPageState.context.parsedQuery), [logStreamPageState.context.parsedQuery]);
  const highlightsProps = {
    logViewReference,
    sourceVersion: logView === null || logView === void 0 ? void 0 : logView.version,
    entriesStart: topCursor,
    entriesEnd: bottomCursor,
    centerCursor: entries.length > 0 ? entries[Math.floor(entries.length / 2)].cursor : null,
    size: entries.length,
    filterQuery: serializedParsedQuery
  };
  return /*#__PURE__*/_react.default.createElement(_log_highlights.LogHighlightsStateProvider, highlightsProps, children);
};
const LogStreamPageContentProviders = ({
  children,
  logStreamPageState,
  logStreamPageCallbacks
}) => {
  return /*#__PURE__*/_react.default.createElement(_log_view_configuration.LogViewConfigurationProvider, null, /*#__PURE__*/_react.default.createElement(_log_flyout.LogEntryFlyoutProvider, null, /*#__PURE__*/_react.default.createElement(_log_position.LogPositionStateProvider, {
    logStreamPageState: logStreamPageState,
    logStreamPageCallbacks: logStreamPageCallbacks
  }, /*#__PURE__*/_react.default.createElement(ViewLogInContext, null, /*#__PURE__*/_react.default.createElement(LogEntriesStateProvider, {
    logStreamPageState: logStreamPageState
  }, /*#__PURE__*/_react.default.createElement(LogHighlightsState, {
    logStreamPageState: logStreamPageState
  }, children))))));
};
exports.LogStreamPageContentProviders = LogStreamPageContentProviders;