"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamPage = void 0;
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _use_kibana = require("../../../hooks/use_kibana");
var _use_logs_breadcrumbs = require("../../../hooks/use_logs_breadcrumbs");
var _use_log_view = require("../../../hooks/use_log_view");
var _state = require("../../../observability_logs/log_stream_page/state");
var _translations = require("../../../translations");
var _kbn_url_state_context = require("../../../utils/kbn_url_state_context");
var _use_kibana_query_settings = require("../../../utils/use_kibana_query_settings");
var _page_content = require("./page_content");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StreamPage = () => {
  (0, _public.useTrackPageview)({
    app: 'infra_logs',
    path: 'stream'
  });
  (0, _public.useTrackPageview)({
    app: 'infra_logs',
    path: 'stream',
    delay: 15000
  });
  (0, _use_logs_breadcrumbs.useLogsBreadcrumbs)([{
    text: _translations.streamTitle
  }]);
  const {
    logViewStateNotifications
  } = (0, _use_log_view.useLogViewContext)();
  const {
    services: {
      data: {
        query: {
          queryString: queryStringService,
          filterManager: filterManagerService,
          timefilter: {
            timefilter: timeFilterService
          }
        }
      },
      notifications: {
        toasts: toastsService
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const kibanaQuerySettings = (0, _use_kibana_query_settings.useKibanaQuerySettings)();
  const urlStateStorage = (0, _kbn_url_state_context.useKbnUrlStateStorageFromRouterContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_state.LogStreamPageStateProvider, {
    kibanaQuerySettings: kibanaQuerySettings,
    logViewStateNotifications: logViewStateNotifications,
    queryStringService: queryStringService,
    toastsService: toastsService,
    filterManagerService: filterManagerService,
    urlStateStorage: urlStateStorage,
    timeFilterService: timeFilterService
  }, /*#__PURE__*/_react.default.createElement(ConnectedStreamPageContentMemo, null)));
};
exports.StreamPage = StreamPage;
const ConnectedStreamPageContentMemo = /*#__PURE__*/_react.default.memo(_page_content.ConnectedStreamPageContent);