"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamLiveButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StreamLiveButton = ({
  isStreaming,
  onStartStreaming,
  onStopStreaming
}) => isStreaming ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  "data-test-subj": "infraStreamLiveButtonStopStreamingButton",
  color: "warning",
  iconSide: "left",
  iconType: "pause",
  onClick: onStopStreaming
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.infra.logs.stopStreamingButtonLabel",
  defaultMessage: "Stop streaming"
})) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  "data-test-subj": "infraStreamLiveButtonStreamLiveButton",
  color: "primary",
  iconSide: "left",
  iconType: "play",
  onClick: onStartStreaming
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.infra.logs.startStreamingButtonLabel",
  defaultMessage: "Stream live"
}));
exports.StreamLiveButton = StreamLiveButton;