"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsSettingsPage = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-plugin/public");
var _source_loading_page = require("../../../components/source_loading_page");
var _use_logs_breadcrumbs = require("../../../hooks/use_logs_breadcrumbs");
var _use_log_view = require("../../../hooks/use_log_view");
var _translations = require("../../../translations");
var _page_template = require("../shared/page_template");
var _indices_configuration_panel = require("./indices_configuration_panel");
var _log_columns_configuration_panel = require("./log_columns_configuration_panel");
var _name_configuration_panel = require("./name_configuration_panel");
var _source_configuration_form_errors = require("./source_configuration_form_errors");
var _source_configuration_form_state = require("./source_configuration_form_state");
var _inline_log_view_callout = require("./inline_log_view_callout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogsSettingsPage = () => {
  var _useKibana$services$a, _uiCapabilities$logs;
  const uiCapabilities = (_useKibana$services$a = (0, _public.useKibana)().services.application) === null || _useKibana$services$a === void 0 ? void 0 : _useKibana$services$a.capabilities;
  const shouldAllowEdit = (uiCapabilities === null || uiCapabilities === void 0 ? void 0 : (_uiCapabilities$logs = uiCapabilities.logs) === null || _uiCapabilities$logs === void 0 ? void 0 : _uiCapabilities$logs.configureSource) === true;
  (0, _public2.useTrackPageview)({
    app: 'infra_logs',
    path: 'log_source_configuration'
  });
  (0, _public2.useTrackPageview)({
    app: 'infra_logs',
    path: 'log_source_configuration',
    delay: 15000
  });
  (0, _use_logs_breadcrumbs.useLogsBreadcrumbs)([{
    text: _translations.settingsTitle
  }]);
  const {
    logView,
    hasFailedLoadingLogView,
    isLoading,
    isUninitialized,
    update,
    resolvedLogView,
    isInlineLogView,
    revertToDefaultLogView
  } = (0, _use_log_view.useLogViewContext)();
  const availableFields = (0, _react.useMemo)(() => {
    var _resolvedLogView$fiel;
    return (_resolvedLogView$fiel = resolvedLogView === null || resolvedLogView === void 0 ? void 0 : resolvedLogView.fields.map(field => field.name)) !== null && _resolvedLogView$fiel !== void 0 ? _resolvedLogView$fiel : [];
  }, [resolvedLogView]);
  const {
    sourceConfigurationFormElement,
    formState,
    logIndicesFormElement,
    logColumnsFormElement,
    nameFormElement
  } = (0, _source_configuration_form_state.useLogSourceConfigurationFormState)(logView === null || logView === void 0 ? void 0 : logView.attributes);
  const persistUpdates = (0, _react.useCallback)(async () => {
    await update(formState);
    sourceConfigurationFormElement.resetValue();
  }, [update, sourceConfigurationFormElement, formState]);
  const isWriteable = (0, _react.useMemo)(() => shouldAllowEdit && logView && logView.origin !== 'internal', [shouldAllowEdit, logView]);
  if ((isLoading || isUninitialized) && !resolvedLogView) {
    return /*#__PURE__*/_react.default.createElement(_source_loading_page.SourceLoadingPage, null);
  }
  if (hasFailedLoadingLogView) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_page_template.LogsPageTemplate, {
    pageHeader: {
      pageTitle: _translations.settingsTitle
    },
    "data-test-subj": "sourceConfigurationContent",
    restrictWidth: true
  }, /*#__PURE__*/_react.default.createElement(_public2.Prompt, {
    prompt: sourceConfigurationFormElement.isDirty ? unsavedFormPromptMessage : undefined
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_name_configuration_panel.NameConfigurationPanel, {
    isLoading: isLoading,
    isReadOnly: !isWriteable,
    nameFormElement: nameFormElement
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_indices_configuration_panel.IndicesConfigurationPanel, {
    isLoading: isLoading,
    isReadOnly: !isWriteable,
    indicesFormElement: logIndicesFormElement
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_log_columns_configuration_panel.LogColumnsConfigurationPanel, {
    availableFields: availableFields,
    isLoading: isLoading,
    logColumnsFormElement: logColumnsFormElement
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), sourceConfigurationFormElement.validity.validity === 'invalid' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_source_configuration_form_errors.LogSourceConfigurationFormErrors, {
    errors: sourceConfigurationFormElement.validity.reasons
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, isWriteable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraLogsSettingsPageLoadingButton",
    color: "primary",
    isLoading: true,
    fill: true
  }, "Loading"))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isInlineLogView && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_inline_log_view_callout.InlineLogViewCallout, {
    revertToDefaultLogView: revertToDefaultLogView
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "discardSettingsButton",
    color: "danger",
    iconType: "cross",
    isDisabled: isLoading || !sourceConfigurationFormElement.isDirty,
    onClick: () => {
      sourceConfigurationFormElement.resetValue();
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.sourceConfiguration.discardSettingsButtonLabel",
    defaultMessage: "Discard"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "applySettingsButton",
    color: "primary",
    isDisabled: !sourceConfigurationFormElement.isDirty || sourceConfigurationFormElement.validity.validity !== 'valid',
    fill: true,
    onClick: persistUpdates
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.sourceConfiguration.applySettingsButtonLabel",
    defaultMessage: "Apply"
  })))))))));
};
exports.LogsSettingsPage = LogsSettingsPage;
const unsavedFormPromptMessage = _i18n.i18n.translate('xpack.infra.logSourceConfiguration.unsavedFormPromptMessage', {
  defaultMessage: 'Are you sure you want to leave? Changes will be lost'
});