"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogColumnsFormElement = void 0;
var _react = require("react");
var _form_elements = require("./form_elements");
var _validation_errors = require("./validation_errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLogColumnsFormElement = initialValue => {
  const logColumnsFormElement = (0, _form_elements.useFormElement)({
    initialValue,
    validate: (0, _react.useMemo)(() => async logColumns => (0, _validation_errors.validateColumnListNotEmpty)(logColumns), [])
  });
  return logColumnsFormElement;
};
exports.useLogColumnsFormElement = useLogColumnsFormElement;