"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicesConfigurationPanel = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-plugin/public");
var _log_views = require("../../../../common/log_views");
var _form_elements = require("./form_elements");
var _index_names_configuration_panel = require("./index_names_configuration_panel");
var _index_pattern_configuration_panel = require("./index_pattern_configuration_panel");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndicesConfigurationPanel = /*#__PURE__*/_react.default.memo(({
  isLoading,
  isReadOnly,
  indicesFormElement
}) => {
  const trackChangeIndexSourceType = (0, _public.useUiTracker)({
    app: 'infra_logs'
  });
  const changeToIndexPatternType = (0, _react.useCallback)(() => {
    if (_log_views.logDataViewReferenceRT.is(indicesFormElement.initialValue)) {
      indicesFormElement.updateValue(() => indicesFormElement.initialValue);
    } else {
      indicesFormElement.updateValue(() => undefined);
    }
    trackChangeIndexSourceType({
      metric: 'configuration_switch_to_index_pattern_reference'
    });
  }, [indicesFormElement, trackChangeIndexSourceType]);
  const changeToIndexNameType = (0, _react.useCallback)(() => {
    var _indicesFormElement$i;
    if (((_indicesFormElement$i = indicesFormElement.initialValue) === null || _indicesFormElement$i === void 0 ? void 0 : _indicesFormElement$i.type) === 'index_name') {
      indicesFormElement.updateValue(() => indicesFormElement.initialValue);
    } else {
      indicesFormElement.updateValue(() => ({
        type: 'index_name',
        indexName: ''
      }));
    }
    trackChangeIndexSourceType({
      metric: 'configuration_switch_to_index_names_reference'
    });
  }, [indicesFormElement, trackChangeIndexSourceType]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, {
    legend: {
      children: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.logSourceConfiguration.logSourcesTitle",
        defaultMessage: "Log sources"
      })))
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: "dataView",
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logSourceConfiguration.dataViewSectionTitle",
      defaultMessage: "Data view (recommended)"
    }))),
    name: "dataView",
    value: "dataView",
    checked: isDataViewFormElement(indicesFormElement),
    onChange: changeToIndexPatternType,
    disabled: isReadOnly
  }, isDataViewFormElement(indicesFormElement) && /*#__PURE__*/_react.default.createElement(_index_pattern_configuration_panel.IndexPatternConfigurationPanel, {
    isLoading: isLoading,
    isReadOnly: isReadOnly,
    indexPatternFormElement: indicesFormElement
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: "indexNames",
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.sourceConfiguration.indicesSectionTitle",
      defaultMessage: "Indices"
    }))),
    name: "indexNames",
    value: "indexNames",
    checked: isIndexNamesFormElement(indicesFormElement),
    onChange: changeToIndexNameType,
    disabled: isReadOnly
  }, isIndexNamesFormElement(indicesFormElement) && /*#__PURE__*/_react.default.createElement(_index_names_configuration_panel.IndexNamesConfigurationPanel, {
    isLoading: isLoading,
    isReadOnly: isReadOnly,
    indexNamesFormElement: indicesFormElement
  })));
});
exports.IndicesConfigurationPanel = IndicesConfigurationPanel;
const isDataViewFormElement = (0, _form_elements.isFormElementForType)(value => value == null || _log_views.logDataViewReferenceRT.is(value));
const isIndexNamesFormElement = (0, _form_elements.isFormElementForType)(_log_views.logIndexNameReferenceRT.is);