"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexNamesConfigurationPanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-plugin/public");
var _form_field_props = require("./form_field_props");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndexNamesConfigurationPanel = ({
  isLoading,
  isReadOnly,
  indexNamesFormElement
}) => {
  (0, _public.useTrackPageview)({
    app: 'infra_logs',
    path: 'log_source_configuration_index_name'
  });
  (0, _public.useTrackPageview)({
    app: 'infra_logs',
    path: 'log_source_configuration_index_name',
    delay: 15000
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.sourceConfiguration.logIndicesTitle",
      defaultMessage: "Log indices"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.sourceConfiguration.logIndicesDescription",
      defaultMessage: "Index pattern for matching indices that contain log data"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.sourceConfiguration.logIndicesRecommendedValue",
      defaultMessage: "The recommended value is {defaultValue}",
      values: {
        defaultValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "logs-*,filebeat-*")
      }
    }),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.sourceConfiguration.logIndicesLabel",
      defaultMessage: "Log indices"
    })
  }, (0, _form_field_props.getFormRowProps)(indexNamesFormElement)), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    "data-test-subj": "logIndicesInput",
    fullWidth: true,
    disabled: isLoading,
    isLoading: isLoading,
    readOnly: isReadOnly
  }, getIndexNamesInputFieldProps(indexNamesFormElement))))));
};
exports.IndexNamesConfigurationPanel = IndexNamesConfigurationPanel;
const getIndexNamesInputFieldProps = (0, _form_field_props.getInputFieldProps)(value => ({
  type: 'index_name',
  indexName: value
}), ({
  indexName
}) => indexName);