"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsPageProviders = void 0;
var _react = _interopRequireWildcard(require("react"));
var _log_analysis = require("../../containers/logs/log_analysis");
var _use_kibana = require("../../hooks/use_kibana");
var _use_log_view = require("../../hooks/use_log_view");
var _url_state_storage_service = require("../../observability_logs/log_view_state/src/url_state_storage_service");
var _kbn_url_state_context = require("../../utils/kbn_url_state_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogsPageProviders = ({
  children
}) => {
  const {
    services: {
      notifications: {
        toasts: toastsService
      },
      logViews: {
        client
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const urlStateStorage = (0, _kbn_url_state_context.useKbnUrlStateStorageFromRouterContext)();
  const [initializeFromUrl] = (0, _react.useState)(() => {
    return (0, _url_state_storage_service.initializeFromUrl)({
      toastsService,
      urlStateStorage
    });
  });
  const [updateContextInUrl] = (0, _react.useState)(() => {
    return (0, _url_state_storage_service.updateContextInUrl)({
      toastsService,
      urlStateStorage
    });
  });
  const [listenForUrlChanges] = (0, _react.useState)(() => {
    return (0, _url_state_storage_service.listenForUrlChanges)({
      urlStateStorage
    });
  });
  return /*#__PURE__*/_react.default.createElement(_use_log_view.LogViewProvider, {
    logViews: client,
    initializeFromUrl: initializeFromUrl,
    updateContextInUrl: updateContextInUrl,
    listenForUrlChanges: listenForUrlChanges
  }, /*#__PURE__*/_react.default.createElement(_log_analysis.LogAnalysisCapabilitiesProvider, null, children));
};
exports.LogsPageProviders = LogsPageProviders;