"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.callGetLogEntryExamplesAPI = void 0;
var _log_analysis = require("../../../../../common/http_api/log_analysis");
var _runtime_types = require("../../../../../common/runtime_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const callGetLogEntryExamplesAPI = async (requestArgs, fetch) => {
  const {
    logViewReference,
    startTime,
    endTime,
    dataset,
    exampleCount,
    categoryId
  } = requestArgs;
  const response = await fetch(_log_analysis.LOG_ANALYSIS_GET_LOG_ENTRY_RATE_EXAMPLES_PATH, {
    method: 'POST',
    body: JSON.stringify(_log_analysis.getLogEntryExamplesRequestPayloadRT.encode({
      data: {
        dataset,
        exampleCount,
        logView: logViewReference,
        timeRange: {
          startTime,
          endTime
        },
        categoryId
      }
    }))
  });
  return (0, _runtime_types.decodeOrThrow)(_log_analysis.getLogEntryExamplesSuccessReponsePayloadRT)(response);
};
exports.callGetLogEntryExamplesAPI = callGetLogEntryExamplesAPI;