"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.callGetLogEntryAnomaliesDatasetsAPI = void 0;
var _runtime_types = require("../../../../../common/runtime_types");
var _log_analysis = require("../../../../../common/http_api/log_analysis");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const callGetLogEntryAnomaliesDatasetsAPI = async (requestArgs, fetch) => {
  const {
    logViewReference,
    startTime,
    endTime
  } = requestArgs;
  const response = await fetch(_log_analysis.LOG_ANALYSIS_GET_LOG_ENTRY_ANOMALIES_DATASETS_PATH, {
    method: 'POST',
    body: JSON.stringify(_log_analysis.getLogEntryAnomaliesDatasetsRequestPayloadRT.encode({
      data: {
        logView: logViewReference,
        timeRange: {
          startTime,
          endTime
        }
      }
    }))
  });
  return (0, _runtime_types.decodeOrThrow)(_log_analysis.getLogEntryAnomaliesDatasetsSuccessReponsePayloadRT)(response);
};
exports.callGetLogEntryAnomaliesDatasetsAPI = callGetLogEntryAnomaliesDatasetsAPI;