"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SORT_DEFAULTS = exports.PAGINATION_DEFAULTS = exports.LogEntryRateResultsContent = void 0;
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _queryString = require("query-string");
var _react = _interopRequireWildcard(require("react"));
var _rison = require("@kbn/rison");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/ml-plugin/public");
var _public3 = require("@kbn/observability-plugin/public");
var _log_analysis = require("../../../../common/log_analysis");
var _log_analysis_job_status = require("../../../components/logging/log_analysis_job_status");
var _datasets_selector = require("../../../components/logging/log_analysis_results/datasets_selector");
var _manage_jobs_button = require("../../../components/logging/log_analysis_setup/manage_jobs_button");
var _setup_flyout = require("../../../components/logging/log_analysis_setup/setup_flyout");
var _log_entry_flyout = require("../../../components/logging/log_entry_flyout");
var _log_analysis_capabilities = require("../../../containers/logs/log_analysis/log_analysis_capabilities");
var _log_entry_categories = require("../../../containers/logs/log_analysis/modules/log_entry_categories");
var _log_entry_rate = require("../../../containers/logs/log_analysis/modules/log_entry_rate");
var _log_flyout = require("../../../containers/logs/log_flyout");
var _use_log_view = require("../../../hooks/use_log_view");
var _page_template = require("../shared/page_template");
var _anomalies = require("./sections/anomalies");
var _use_dataset_filtering = require("./use_dataset_filtering");
var _use_log_entry_anomalies_results = require("./use_log_entry_anomalies_results");
var _use_log_entry_rate_results_url_state = require("./use_log_entry_rate_results_url_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SORT_DEFAULTS = {
  direction: 'desc',
  field: 'anomalyScore'
};
exports.SORT_DEFAULTS = SORT_DEFAULTS;
const PAGINATION_DEFAULTS = {
  pageSize: 25
};
exports.PAGINATION_DEFAULTS = PAGINATION_DEFAULTS;
const LogEntryRateResultsContent = ({
  pageTitle
}) => {
  var _useKibana$services$a;
  (0, _public3.useTrackPageview)({
    app: 'infra_logs',
    path: 'log_entry_rate_results'
  });
  (0, _public3.useTrackPageview)({
    app: 'infra_logs',
    path: 'log_entry_rate_results',
    delay: 15000
  });
  const navigateToApp = (_useKibana$services$a = (0, _public.useKibana)().services.application) === null || _useKibana$services$a === void 0 ? void 0 : _useKibana$services$a.navigateToApp;
  const {
    logViewReference,
    logViewStatus
  } = (0, _use_log_view.useLogViewContext)();
  if (logViewReference.type === 'log-view-inline') {
    throw new Error('Logs ML features only support persisted Log Views');
  }
  const {
    hasLogAnalysisSetupCapabilities
  } = (0, _log_analysis_capabilities.useLogAnalysisCapabilitiesContext)();
  const {
    hasOutdatedJobConfigurations: hasOutdatedLogEntryRateJobConfigurations,
    hasOutdatedJobDefinitions: hasOutdatedLogEntryRateJobDefinitions,
    hasStoppedJobs: hasStoppedLogEntryRateJobs,
    moduleDescriptor: logEntryRateModuleDescriptor,
    setupStatus: logEntryRateSetupStatus,
    jobStatus: logEntryRateJobStatus,
    jobIds: logEntryRateJobIds
  } = (0, _log_entry_rate.useLogEntryRateModuleContext)();
  const {
    categoryQualityWarnings,
    hasOutdatedJobConfigurations: hasOutdatedLogEntryCategoriesJobConfigurations,
    hasOutdatedJobDefinitions: hasOutdatedLogEntryCategoriesJobDefinitions,
    hasStoppedJobs: hasStoppedLogEntryCategoriesJobs,
    moduleDescriptor: logEntryCategoriesModuleDescriptor,
    setupStatus: logEntryCategoriesSetupStatus,
    jobStatus: logEntryCategoriesJobStatus,
    jobIds: logEntryCategoriesJobIds
  } = (0, _log_entry_categories.useLogEntryCategoriesModuleContext)();
  const jobIds = (0, _react.useMemo)(() => {
    return [...((0, _log_analysis.isJobStatusWithResults)(logEntryRateJobStatus['log-entry-rate']) ? [logEntryRateJobIds['log-entry-rate']] : []), ...((0, _log_analysis.isJobStatusWithResults)(logEntryCategoriesJobStatus['log-entry-categories-count']) ? [logEntryCategoriesJobIds['log-entry-categories-count']] : [])];
  }, [logEntryRateJobIds, logEntryCategoriesJobIds, logEntryRateJobStatus, logEntryCategoriesJobStatus]);
  const {
    timeRange,
    friendlyTimeRange,
    setTimeRange: setSelectedTimeRange,
    autoRefresh,
    setAutoRefresh
  } = (0, _use_log_entry_rate_results_url_state.useLogAnalysisResultsUrlState)();
  const {
    closeFlyout: closeLogEntryFlyout,
    isFlyoutOpen: isLogEntryFlyoutOpen,
    logEntryId: flyoutLogEntryId
  } = (0, _log_flyout.useLogEntryFlyoutContext)();
  const linkToLogStream = (0, _react.useCallback)((filterQuery, id, timeKey) => {
    const params = {
      logPosition: (0, _rison.encode)({
        end: (0, _moment.default)(timeRange.value.endTime).format('YYYY-MM-DDTHH:mm:ss.SSSZ'),
        position: timeKey,
        start: (0, _moment.default)(timeRange.value.startTime).format('YYYY-MM-DDTHH:mm:ss.SSSZ'),
        streamLive: false
      }),
      flyoutOptions: (0, _rison.encode)({
        surroundingLogsId: id
      }),
      logFilter: (0, _rison.encode)(filterQuery)
    };
    navigateToApp === null || navigateToApp === void 0 ? void 0 : navigateToApp('logs', {
      path: `/stream?${(0, _queryString.stringify)(params)}`
    });
  }, [timeRange, navigateToApp]);
  const {
    selectedDatasets,
    setSelectedDatasets
  } = (0, _use_dataset_filtering.useDatasetFiltering)();
  const {
    isLoadingLogEntryAnomalies,
    logEntryAnomalies,
    page,
    fetchNextPage,
    fetchPreviousPage,
    changeSortOptions,
    changePaginationOptions,
    sortOptions,
    paginationOptions,
    datasets,
    isLoadingDatasets
  } = (0, _use_log_entry_anomalies_results.useLogEntryAnomaliesResults)({
    logViewReference,
    startTime: timeRange.value.startTime,
    endTime: timeRange.value.endTime,
    defaultSortOptions: SORT_DEFAULTS,
    defaultPaginationOptions: PAGINATION_DEFAULTS,
    filteredDatasets: selectedDatasets
  });
  const handleAutoRefreshChange = (0, _react.useCallback)(({
    isPaused,
    refreshInterval: interval
  }) => {
    setAutoRefresh({
      isPaused,
      interval
    });
  }, [setAutoRefresh]);
  const {
    showModuleList,
    showModuleSetup
  } = (0, _setup_flyout.useLogAnalysisSetupFlyoutStateContext)();
  const showLogEntryRateSetup = (0, _react.useCallback)(() => showModuleSetup('logs_ui_analysis'), [showModuleSetup]);
  const showLogEntryCategoriesSetup = (0, _react.useCallback)(() => showModuleSetup('logs_ui_categories'), [showModuleSetup]);
  const hasAnomalyResults = logEntryAnomalies.length > 0;
  const isFirstUse = (0, _react.useMemo)(() => (logEntryCategoriesSetupStatus.type === 'skipped' && !!logEntryCategoriesSetupStatus.newlyCreated || logEntryCategoriesSetupStatus.type === 'succeeded' || logEntryRateSetupStatus.type === 'skipped' && !!logEntryRateSetupStatus.newlyCreated || logEntryRateSetupStatus.type === 'succeeded') && !hasAnomalyResults, [hasAnomalyResults, logEntryCategoriesSetupStatus, logEntryRateSetupStatus]);
  const handleSelectedTimeRangeChange = (0, _react.useCallback)(selectedTime => {
    if (selectedTime.isInvalid) {
      return;
    }
    setSelectedTimeRange(selectedTime);
  }, [setSelectedTimeRange]);
  return /*#__PURE__*/_react.default.createElement(_page_template.LogsPageTemplate, {
    hasData: (logViewStatus === null || logViewStatus === void 0 ? void 0 : logViewStatus.index) !== 'missing',
    pageHeader: {
      pageTitle,
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_manage_jobs_button.ManageJobsButton, {
        onClick: showModuleList,
        size: "s"
      })]
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_datasets_selector.DatasetsSelector, {
    availableDatasets: datasets,
    isLoading: isLoadingDatasets,
    selectedDatasets: selectedDatasets,
    onChangeDatasetSelection: setSelectedDatasets
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    start: friendlyTimeRange.startTime,
    end: friendlyTimeRange.endTime,
    onTimeChange: handleSelectedTimeRangeChange,
    isPaused: autoRefresh.isPaused,
    refreshInterval: autoRefresh.interval,
    onRefreshChange: handleAutoRefreshChange
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_log_analysis_job_status.LogAnalysisJobProblemIndicator, {
    hasOutdatedJobConfigurations: hasOutdatedLogEntryRateJobConfigurations,
    hasOutdatedJobDefinitions: hasOutdatedLogEntryRateJobDefinitions,
    hasSetupCapabilities: hasLogAnalysisSetupCapabilities,
    hasStoppedJobs: hasStoppedLogEntryRateJobs,
    isFirstUse: false /* the first use message is already shown by the section below */,
    moduleName: logEntryRateModuleDescriptor.moduleName,
    onRecreateMlJobForReconfiguration: showLogEntryRateSetup,
    onRecreateMlJobForUpdate: showLogEntryRateSetup
  }), /*#__PURE__*/_react.default.createElement(_public2.MLJobsAwaitingNodeWarning, {
    jobIds: jobIds
  }), /*#__PURE__*/_react.default.createElement(_log_analysis_job_status.CategoryJobNoticesSection, {
    hasOutdatedJobConfigurations: hasOutdatedLogEntryCategoriesJobConfigurations,
    hasOutdatedJobDefinitions: hasOutdatedLogEntryCategoriesJobDefinitions,
    hasSetupCapabilities: hasLogAnalysisSetupCapabilities,
    hasStoppedJobs: hasStoppedLogEntryCategoriesJobs,
    isFirstUse: isFirstUse,
    moduleName: logEntryCategoriesModuleDescriptor.moduleName,
    onRecreateMlJobForReconfiguration: showLogEntryCategoriesSetup,
    onRecreateMlJobForUpdate: showLogEntryCategoriesSetup,
    qualityWarnings: categoryQualityWarnings
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_anomalies.AnomaliesResults, {
    isLoadingAnomaliesResults: isLoadingLogEntryAnomalies,
    anomalies: logEntryAnomalies,
    timeRange: timeRange.value,
    page: page,
    fetchNextPage: fetchNextPage,
    fetchPreviousPage: fetchPreviousPage,
    changeSortOptions: changeSortOptions,
    changePaginationOptions: changePaginationOptions,
    sortOptions: sortOptions,
    paginationOptions: paginationOptions,
    selectedDatasets: selectedDatasets,
    jobIds: jobIds,
    autoRefresh: autoRefresh
  }))), isLogEntryFlyoutOpen ? /*#__PURE__*/_react.default.createElement(_log_entry_flyout.LogEntryFlyout, {
    logEntryId: flyoutLogEntryId,
    onCloseFlyout: closeLogEntryFlyout,
    onSetFieldFilter: linkToLogStream,
    logViewReference: logViewReference
  }) : null);
};
exports.LogEntryRateResultsContent = LogEntryRateResultsContent;