"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogEntryCategoriesResultsUrlState = exports.stringTimeRangeRT = void 0;
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _pipeable = require("fp-ts/lib/pipeable");
var rt = _interopRequireWildcard(require("io-ts"));
var _use_url_state = require("../../../utils/use_url_state");
var _use_kibana_timefilter_time = require("../../../hooks/use_kibana_timefilter_time");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const autoRefreshRT = rt.union([rt.type({
  interval: rt.number,
  isPaused: rt.boolean
}), rt.undefined]);
const stringTimeRangeRT = rt.type({
  startTime: rt.string,
  endTime: rt.string
});
exports.stringTimeRangeRT = stringTimeRangeRT;
const urlTimeRangeRT = rt.union([stringTimeRangeRT, rt.undefined]);
const TIME_RANGE_URL_STATE_KEY = 'timeRange';
const AUTOREFRESH_URL_STATE_KEY = 'autoRefresh';
const TIME_DEFAULTS = {
  from: 'now-2w',
  to: 'now'
};
const useLogEntryCategoriesResultsUrlState = () => {
  const [getTime] = (0, _use_kibana_timefilter_time.useKibanaTimefilterTime)(TIME_DEFAULTS);
  const {
    from: start,
    to: end
  } = getTime();
  const [timeRange, setTimeRange] = (0, _use_url_state.useUrlState)({
    defaultState: {
      startTime: start,
      endTime: end
    },
    decodeUrlState: value => (0, _pipeable.pipe)(urlTimeRangeRT.decode(value), (0, _Either.fold)((0, _function.constant)(undefined), _function.identity)),
    encodeUrlState: urlTimeRangeRT.encode,
    urlStateKey: TIME_RANGE_URL_STATE_KEY,
    writeDefaultState: true
  });
  (0, _use_kibana_timefilter_time.useSyncKibanaTimeFilterTime)(TIME_DEFAULTS, {
    from: timeRange.startTime,
    to: timeRange.endTime
  });
  const [autoRefresh, setAutoRefresh] = (0, _use_url_state.useUrlState)({
    defaultState: {
      isPaused: false,
      interval: 60000
    },
    decodeUrlState: value => (0, _pipeable.pipe)(autoRefreshRT.decode(value), (0, _Either.fold)((0, _function.constant)(undefined), _function.identity)),
    encodeUrlState: autoRefreshRT.encode,
    urlStateKey: AUTOREFRESH_URL_STATE_KEY,
    writeDefaultState: true
  });
  return {
    timeRange,
    setTimeRange,
    autoRefresh,
    setAutoRefresh
  };
};
exports.useLogEntryCategoriesResultsUrlState = useLogEntryCategoriesResultsUrlState;