"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SingleMetricComparison = void 0;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SingleMetricComparison = ({
  currentValue,
  previousValue
}) => {
  const changeFactor = currentValue / previousValue - 1;
  if (changeFactor < 0) {
    return /*#__PURE__*/_react.default.createElement(NoWrapSpan, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "sortDown",
      color: "danger"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "danger"
    }, formatPercentage(changeFactor)));
  } else if (changeFactor > 0 && Number.isFinite(changeFactor)) {
    return /*#__PURE__*/_react.default.createElement(NoWrapSpan, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "sortUp",
      color: "success"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "success"
    }, formatPercentage(changeFactor)));
  } else if (changeFactor > 0 && !Number.isFinite(changeFactor)) {
    return /*#__PURE__*/_react.default.createElement(NoWrapSpan, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "sortUp",
      color: "success"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "success"
    }, newCategoryTrendLabel));
  }
  return null;
};
exports.SingleMetricComparison = SingleMetricComparison;
const formatPercentage = value => (0, _numeral.default)(value).format('+0,0 %');
const newCategoryTrendLabel = _i18n.i18n.translate('xpack.infra.logs.logEntryCategories.newCategoryTrendLabel', {
  defaultMessage: 'new'
});
const NoWrapSpan = _common.euiStyled.span`
  white-space: nowrap;
`;