"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyzeCategoryDatasetInMlAction = void 0;
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/ml-plugin/public");
var _public2 = require("@kbn/observability-plugin/public");
var _use_kibana = require("../../../../../hooks/use_kibana");
var _job_parameters = require("../../../../../../common/log_analysis/job_parameters");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnalyzeCategoryDatasetInMlAction = ({
  categorizationJobId,
  categoryId,
  dataset,
  timeRange
}) => {
  const {
    services: {
      ml,
      http,
      application
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const viewAnomalyInMachineLearningLink = (0, _public.useMlHref)(ml, http.basePath.get(), {
    page: _public.ML_PAGES.SINGLE_METRIC_VIEWER,
    pageState: {
      jobIds: [categorizationJobId],
      timeRange: {
        from: (0, _moment.default)(timeRange.startTime).format('YYYY-MM-DDTHH:mm:ss.SSSZ'),
        to: (0, _moment.default)(timeRange.endTime).format('YYYY-MM-DDTHH:mm:ss.SSSZ'),
        mode: 'absolute'
      },
      entities: {
        [_job_parameters.partitionField]: dataset,
        mlcategory: `${categoryId}`
      }
    }
  }, [categorizationJobId]);
  const handleClick = (0, _react.useCallback)(e => {
    if (!viewAnomalyInMachineLearningLink || !(0, _public2.shouldHandleLinkEvent)(e)) return;
    application.navigateToUrl(viewAnomalyInMachineLearningLink);
  }, [application, viewAnomalyInMachineLearningLink]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: analyseCategoryDatasetInMlTooltipDescription,
    delay: "long"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": analyseCategoryDatasetInMlButtonLabel,
    iconType: "machineLearningApp",
    "data-test-subj": "analyzeCategoryDatasetInMlButton",
    href: viewAnomalyInMachineLearningLink,
    onClick: handleClick
  }));
};
exports.AnalyzeCategoryDatasetInMlAction = AnalyzeCategoryDatasetInMlAction;
const analyseCategoryDatasetInMlButtonLabel = _i18n.i18n.translate('xpack.infra.logs.logEntryCategories.analyzeCategoryInMlButtonLabel', {
  defaultMessage: 'Analyze in ML'
});
const analyseCategoryDatasetInMlTooltipDescription = _i18n.i18n.translate('xpack.infra.logs.logEntryCategories.analyzeCategoryInMlTooltipDescription', {
  defaultMessage: 'Analyze this category in the ML app.'
});