"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNodeLogsUrl = exports.RedirectToNodeLogs = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _lodash = require("lodash");
var _inventory_models = require("../../../common/inventory_models");
var _loading_page = require("../../components/loading_page");
var _use_kibana = require("../../hooks/use_kibana");
var _use_log_view = require("../../hooks/use_log_view");
var _log_stream_query_state = require("../../observability_logs/log_stream_query_state");
var _query_params = require("./query_params");
var _url_state_storage_service = require("../../observability_logs/log_stream_position_state/src/url_state_storage_service");
var _log_view_state = require("../../observability_logs/log_view_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RedirectToNodeLogs = ({
  match: {
    params: {
      nodeId,
      nodeType,
      logViewId = 'default'
    }
  },
  location
}) => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    isLoading,
    load
  } = (0, _use_log_view.useLogView)({
    initialLogViewReference: {
      type: 'log-view-reference',
      logViewId
    },
    logViews: services.logViews.client
  });
  (0, _useMount.default)(() => {
    load();
  });
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_loading_page.LoadingPage, {
      "data-test-subj": `nodeLoadingPage-${nodeType}`,
      message: _i18n.i18n.translate('xpack.infra.redirectToNodeLogs.loadingNodeLogsMessage', {
        defaultMessage: 'Loading {nodeType} logs',
        values: {
          nodeType
        }
      })
    });
  }
  const nodeFilter = `${(0, _inventory_models.findInventoryFields)(nodeType).id}: ${nodeId}`;
  const userFilter = (0, _query_params.getFilterFromLocation)(location);
  const filter = userFilter ? `(${nodeFilter}) and (${userFilter})` : nodeFilter;
  const time = (0, _query_params.getTimeFromLocation)(location);
  const searchString = (0, _lodash.flowRight)((0, _log_stream_query_state.replaceLogFilterInQueryString)({
    language: 'kuery',
    query: filter
  }, time), (0, _url_state_storage_service.replaceLogPositionInQueryString)(time), (0, _log_view_state.replaceLogViewInQueryString)({
    type: 'log-view-reference',
    logViewId
  }))('');
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: `/stream?${searchString}`
  });
};
exports.RedirectToNodeLogs = RedirectToNodeLogs;
const getNodeLogsUrl = ({
  nodeId,
  nodeType,
  time
}) => {
  return {
    app: 'logs',
    pathname: `link-to/${nodeType}-logs/${nodeId}`,
    search: time ? {
      time: `${time}`
    } : undefined
  };
};
exports.getNodeLogsUrl = getNodeLogsUrl;