"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RedirectToLogs = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _lodash = require("lodash");
var _url_state_storage_service = require("../../observability_logs/log_stream_position_state/src/url_state_storage_service");
var _log_stream_query_state = require("../../observability_logs/log_stream_query_state");
var _query_params = require("./query_params");
var _log_view_state = require("../../observability_logs/log_view_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RedirectToLogs = ({
  location,
  match
}) => {
  const logViewId = match.params.logViewId || 'default';
  const filter = (0, _query_params.getFilterFromLocation)(location);
  const time = (0, _query_params.getTimeFromLocation)(location);
  const searchString = (0, _lodash.flowRight)((0, _log_stream_query_state.replaceLogFilterInQueryString)({
    language: 'kuery',
    query: filter
  }, time), (0, _url_state_storage_service.replaceLogPositionInQueryString)(time), (0, _log_view_state.replaceLogViewInQueryString)({
    type: 'log-view-reference',
    logViewId
  }))('');
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: `/stream?${searchString}`
  });
};
exports.RedirectToLogs = RedirectToLogs;