"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateQuery = exports.showValidationErrorToast = void 0;
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _errors = require("./errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateQuery = ({
  kibanaQuerySettings
}) => context => send => {
  if (!('query' in context)) {
    throw new Error('Failed to validate query: no query in context');
  }
  const {
    dataViews,
    query,
    filters
  } = context;
  if (!(0, _esQuery.isOfQueryType)(query)) {
    send({
      type: 'VALIDATION_FAILED',
      error: new _errors.UnsupportedLanguageError('Failed to validate query: unsupported language')
    });
    return;
  }
  try {
    const parsedQuery = (0, _esQuery.buildEsQuery)(dataViews, query, filters, kibanaQuerySettings);
    send({
      type: 'VALIDATION_SUCCEEDED',
      parsedQuery
    });
  } catch (error) {
    send({
      type: 'VALIDATION_FAILED',
      error: new _errors.QueryParsingError(`${error}`)
    });
  }
};
exports.validateQuery = validateQuery;
const showValidationErrorToast = ({
  toastsService
}) => (_context, event) => {
  if (event.type !== 'VALIDATION_FAILED') {
    return;
  }
  toastsService.addError(event.error, {
    title: validationErrorToastTitle
  });
};
exports.showValidationErrorToast = showValidationErrorToast;
const validationErrorToastTitle = _i18n.i18n.translate('xpack.infra.logsPage.toolbar.logFilterErrorToastTitle', {
  defaultMessage: 'Log filter error'
});