"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMetricsHasData = exports.createMetricsFetchData = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Copyright
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createMetricsHasData = getStartServices => async () => {
  const [coreServices] = await getStartServices();
  const {
    http
  } = coreServices;
  const results = await http.get('/api/metrics/source/default/hasData');
  return {
    hasData: results.hasData,
    indices: results.configuration.metricAlias
  };
};
exports.createMetricsHasData = createMetricsHasData;
const createMetricsFetchData = getStartServices => async ({
  absoluteTime,
  intervalString
}) => {
  const [coreServices] = await getStartServices();
  const {
    http
  } = coreServices;
  const makeRequest = async (overrides = {}) => {
    const {
      start,
      end
    } = absoluteTime;
    const overviewRequest = {
      sourceId: 'default',
      bucketSize: intervalString,
      size: 5,
      timerange: {
        from: start,
        to: end
      },
      ...overrides
    };
    const results = await http.post('/api/metrics/overview/top', {
      body: JSON.stringify(overviewRequest)
    });
    return {
      appLink: `/app/metrics/inventory?waffleTime=(currentTime:${end},isAutoReloading:!f)`,
      series: results.series,
      sort: async (by, direction) => makeRequest({
        sort: by,
        sortDirection: direction
      })
    };
  };
  return await makeRequest();
};
exports.createMetricsFetchData = createMetricsFetchData;