"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateSavedObject = void 0;
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUpdateSavedObject = type => {
  const kibana = (0, _public.useKibana)();
  const [data, setData] = (0, _react.useState)(null);
  const [updatedId, setUpdatedId] = (0, _react.useState)(null);
  const [error, setError] = (0, _react.useState)(null);
  const [loading, setLoading] = (0, _react.useState)(false);
  const update = (0, _react.useCallback)((id, attributes, options) => {
    setLoading(true);
    const save = async () => {
      try {
        var _kibana$services$save;
        const savedObjectsClient = (_kibana$services$save = kibana.services.savedObjects) === null || _kibana$services$save === void 0 ? void 0 : _kibana$services$save.client;
        if (!savedObjectsClient) {
          throw new Error('Saved objects client is unavailable');
        }
        const d = await savedObjectsClient.update(type, id, attributes, options);
        setUpdatedId(d.id);
        setError(null);
        setData(d);
        setLoading(false);
      } catch (e) {
        setLoading(false);
        setError(e);
      }
    };
    save();
  }, [type, kibana.services.savedObjects]);
  return {
    data,
    loading,
    error,
    update,
    updatedId
  };
};
exports.useUpdateSavedObject = useUpdateSavedObject;