"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLensAttributes = void 0;
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _visualizations = require("../common/visualizations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLensAttributes = ({
  type,
  dataView,
  options,
  visualizationType
}) => {
  const {
    services: {
      lens
    }
  } = (0, _public.useKibana)();
  const {
    navigateToPrefilledEditor
  } = lens;
  const {
    value,
    error
  } = (0, _useAsync.default)(lens.stateHelperApi, [lens]);
  const {
    formula: formulaAPI
  } = value !== null && value !== void 0 ? value : {};
  const attributes = (0, _react.useMemo)(() => {
    if (!dataView || !formulaAPI) {
      return null;
    }
    const lensChartConfig = _visualizations.hostLensFormulas[type];
    const VisualizationType = _visualizations.visualizationTypes[visualizationType];
    const visualizationAttributes = (0, _visualizations.buildLensAttributes)(new VisualizationType(lensChartConfig, dataView, formulaAPI, options));
    return visualizationAttributes;
  }, [dataView, formulaAPI, options, type, visualizationType]);
  const injectFilters = ({
    filters,
    query = {
      language: 'kuery',
      query: ''
    }
  }) => {
    if (!attributes) {
      return null;
    }
    return {
      ...attributes,
      state: {
        ...attributes.state,
        query,
        filters: [...attributes.state.filters, ...filters]
      }
    };
  };
  const getExtraActions = ({
    timeRange,
    filters,
    query
  }) => {
    return {
      openInLens: {
        id: 'openInLens',
        getDisplayName(_context) {
          return _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.metricsCharts.actions.openInLines', {
            defaultMessage: 'Open in Lens'
          });
        },
        getIconType(_context) {
          return 'visArea';
        },
        type: 'actionButton',
        async isCompatible(_context) {
          return true;
        },
        async execute(_context) {
          const injectedAttributes = injectFilters({
            filters,
            query
          });
          if (injectedAttributes) {
            navigateToPrefilledEditor({
              id: '',
              timeRange,
              attributes: injectedAttributes
            }, {
              openInNewTab: true
            });
          }
        },
        order: 100
      }
    };
  };
  return {
    attributes,
    getExtraActions,
    error
  };
};
exports.useLensAttributes = useLensAttributes;