"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIntersectedOnce = void 0;
var _react = require("react");
var _useIntersection = _interopRequireDefault(require("react-use/lib/useIntersection"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIntersectedOnce = (ref, options) => {
  const [intersectedOnce, setIntersectedOnce] = (0, _react.useState)(false);
  const intersection = (0, _useIntersection.default)(ref, options);
  (0, _react.useEffect)(() => {
    var _intersection$interse;
    if (!intersectedOnce && ((_intersection$interse = intersection === null || intersection === void 0 ? void 0 : intersection.intersectionRatio) !== null && _intersection$interse !== void 0 ? _intersection$interse : 0) > 0) {
      setIntersectedOnce(true);
    }
  }, [intersectedOnce, intersection === null || intersection === void 0 ? void 0 : intersection.intersectionRatio]);
  return {
    intersectedOnce,
    intersection
  };
};
exports.useIntersectedOnce = useIntersectedOnce;