"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetSavedObject = void 0;
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetSavedObject = type => {
  const kibana = (0, _public.useKibana)();
  const [data, setData] = (0, _react.useState)(null);
  const [error, setError] = (0, _react.useState)(null);
  const [loading, setLoading] = (0, _react.useState)(false);
  const getObject = (0, _react.useCallback)(id => {
    setLoading(true);
    const fetchData = async () => {
      try {
        var _kibana$services$save;
        const savedObjectsClient = (_kibana$services$save = kibana.services.savedObjects) === null || _kibana$services$save === void 0 ? void 0 : _kibana$services$save.client;
        if (!savedObjectsClient) {
          throw new Error('Saved objects client is unavailable');
        }
        const d = await savedObjectsClient.get(type, id);
        setError(null);
        setLoading(false);
        setData(d);
      } catch (e) {
        setLoading(false);
        setError(e);
      }
    };
    fetchData();
  }, [type, kibana.services.savedObjects]);
  return {
    data,
    loading,
    error,
    getObject
  };
};
exports.useGetSavedObject = useGetSavedObject;