"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFindSavedObject = void 0;
var _react = require("react");
var _public = require("@kbn/observability-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFindSavedObject = type => {
  const trackMetric = (0, _public.useUiTracker)({
    app: 'infra_metrics'
  });
  const kibana = (0, _public2.useKibana)();
  const [data, setData] = (0, _react.useState)(null);
  const [error, setError] = (0, _react.useState)(null);
  const [loading, setLoading] = (0, _react.useState)(false);
  const find = (0, _react.useCallback)((query, searchFields = []) => {
    setLoading(true);
    const fetchData = async () => {
      try {
        var _kibana$services$save;
        const savedObjectsClient = (_kibana$services$save = kibana.services.savedObjects) === null || _kibana$services$save === void 0 ? void 0 : _kibana$services$save.client;
        if (!savedObjectsClient) {
          throw new Error('Saved objects client is unavailable');
        }
        const d = await savedObjectsClient.find({
          type,
          search: query,
          searchFields,
          page: 1,
          perPage: 1000
        });
        setError(null);
        setLoading(false);
        setData(d);
        if (d.total > 1000) {
          trackMetric({
            metric: `over_1000_saved_objects_for_${type}`
          });
        } else {
          trackMetric({
            metric: `under_1000_saved_objects_for_${type}`
          });
        }
      } catch (e) {
        setLoading(false);
        setError(e);
      }
    };
    fetchData();
  }, [type, kibana.services.savedObjects, trackMetric]);
  const hasView = async name => {
    var _kibana$services$save2;
    const savedObjectsClient = (_kibana$services$save2 = kibana.services.savedObjects) === null || _kibana$services$save2 === void 0 ? void 0 : _kibana$services$save2.client;
    if (!savedObjectsClient) {
      throw new Error('Saved objects client is unavailable');
    }
    const objects = await savedObjectsClient.find({
      type
    });
    return objects.savedObjects.find(o => o.attributes.name === name);
  };
  return {
    hasView,
    data,
    loading,
    error,
    find
  };
};
exports.useFindSavedObject = useFindSavedObject;